<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_master extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('student_master_model');
        $this->load->model('student_enrollment_model');
        check_authenticated();
    }

    function get_area()
    {
        $res = $this->student_master_model->get_area();        
        echo json_encode(array('area' => $res));
    }

    function add_area($area)
    {        
        $res = $this->student_master_model->checkArea($area);
        if(empty($res))
        {
            $this->student_master_model->addArea($area);
        }
    }

    function save_student() {
        $student = $this->_get_student_from_post();
        $validation_message = $this->_validate_student($student);
        if ($validation_message != '') {
            echo json_encode(array('success' => FALSE, 'message' => $validation_message));
            return;
        }

        if($this->input->post('student_lan_chack_box') == 1) 
        {      
            $recipe_language_data = $this->input->post('recipe_language_data');
            $student['lang_preference'] = json_encode($recipe_language_data);
        }   
        else
        {
            $student['lang_preference'] = '';
        }        
        $user_id = get_from_session('ccm_user_id');
        $student['student_created_by'] = $user_id;
        $student_id = $this->student_master_model->create($student);
        $this->add_area($student['student_area']);

        echo json_encode(array('success' => TRUE, 'message' => 'Student Information Saved Successflly', 'student_id' => $student_id));
    }

    function get_all_student() {
        $address = trim($this->input->post('search_address'));
        $reference = trim($this->input->post('search_reference'));
        $gender = trim($this->input->post('search_gender'));
        $group_tag = trim($this->input->post('student_group_tag1'));

        $search_data = array(
            "address" => $address,
            "reference" => $reference == '*' ? '' : $reference,
            "gender" => $gender == '*' ? '' : $gender,
            "group_tag" => $group_tag
        );
        $student_array = $this->student_master_model->get_all_student($search_data);
        echo json_encode($student_array);
    }

    function export_student() {

        $address = trim($this->input->post('search_address'));
        $reference = trim($this->input->post('search_reference'));
        $gender = trim($this->input->post('search_gender'));
        $group_tag = trim($this->input->post('student_group_tag1'));
        $export_type = trim($this->input->post('export_type'));

        $search_data = array(
            "address" => $address,
            "reference" => $reference == '*' ? '' : $reference,
            "gender" => $gender == '*' ? '' : $gender,
            "group_tag" => $group_tag
        );
        $data['student_array'] = $this->student_master_model->get_all_student($search_data);

        if($export_type == 'pdf')
        {
            $output = $this->load->view('report/students_pdf', $data, TRUE);
            $this->load->library('mpdf/MPDF');
            $mpdf = new mPDF('utf-8', 'A4', '', '', 15, 15, 20, 20, 5, 5);
            $mpdf->WriteHTML($output);
            $mpdf->Output("students_pdf.pdf", 'I');
        }
        else
        {
            include_once APPPATH . "libraries/PHPExcel/Classes/PHPExcel.php";
            $objPHPExcel = new PHPExcel();
            $objRichText = new PHPExcel_RichText();

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Student List : '.date('d-m-Y'));

            $objPHPExcel->getActiveSheet()->SetCellValue('A3', 'Sr #');
            $objPHPExcel->getActiveSheet()->SetCellValue('B3', 'Reg. Date');
            $objPHPExcel->getActiveSheet()->SetCellValue('C3', 'Full Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('D3', 'Mobile');
            $objPHPExcel->getActiveSheet()->SetCellValue('E3', 'E-mail');
            $objPHPExcel->getActiveSheet()->SetCellValue('F3', 'City');

            $c=4;
            $i = 1;
            foreach ($data['student_array'] as $student) 
            {
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$c, $i);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$c, date_format(date_create($student['student_registration_date']),'d-m-Y'));
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$c, $student['student_first_name'] . ' ' . $student['student_middle_name'] . ' ' . $student['student_last_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$c, $student['student_mobile']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$c, $student['student_email']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$c, $student['student_city']);
                $c++;
                $i++;
            }

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:F1'); // merge cell

            //set bg color
                $objPHPExcel->getActiveSheet()->getStyle('A1')->getFill()->applyFromArray(array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'startcolor' => array(
                         'rgb' => "538ed5"
                    )
                ));

                $objPHPExcel->getActiveSheet()->getStyle('A3:F3')->getFill()->applyFromArray(array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'startcolor' => array(
                         'rgb' => "8db4e3"
                    )
                ));
            //set bg color

            //set font color
                $styleArray1 = array(
                'font'  => array(
                    'bold' => true,
                    'color' => array('rgb' => 'ffffff'),
                    'size'  => 13,                
                ));

                $styleArray2 = array(
                'font'  => array(
                    'bold' => true,
                    'color' => array('rgb' => 'ffffff'),                               
                ));

                $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray1);
                $objPHPExcel->getActiveSheet()->getStyle('A3:F3')->applyFromArray($styleArray2);
            //set font color

            //set autosize
                for($col = 'A'; $col !== 'F'; $col++) {
                    $objPHPExcel->getActiveSheet()
                        ->getColumnDimension($col)
                        ->setAutoSize(true);
                }
            //set autosize

            //set left
                $style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
                    )
                );
                for($i=2;$i<=$c-1;$i++)
                {
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$i.':F'.$i)->applyFromArray($style);
                }
            //set left

            //set border
                $border_style = array(
                    'borders' => array(
                        'outline' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('rgb' => '538ed5'),
                        ),
                    ),
                );             
                $objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('C3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('D3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('E3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('F3')->applyFromArray($border_style);               
                              
            //set border

            $filename ='students_excel.xls';
            $objPHPExcel->getActiveSheet()->setTitle('Student');
            $objPHPExcel->setActiveSheetIndex(0);
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");            
            header("Content-Disposition: attachment;filename=\"".$filename."\";");
            header("Cache-Control: max-age=1");
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
        }

        
    }   

    function get_by_student_id() {
        $student_id = $this->input->post('student_id');
        $student_array = $this->_get_student_data_by_student_id($student_id);
        $student_array['lang_preference'] = json_decode($student_array['lang_preference']);
        echo json_encode($student_array);
    }

    function view_student() {
        $student_id = $this->input->post('student_id');
        $student_array = $this->_get_student_data_by_student_id($student_id);
        $payment_details = $this->data_lib->get_payment_detail($student_id);
        $total = 0;
        $paid = 0;
        $due = 0;
        $discount = 0;
        foreach ($payment_details as $r) {
            $total += $r['sub_total'];
            $paid += $r['pay_amount'];
            $due += $r['due_amounts'];
            $discount += $r['discount'];
            $total_discount += $r['total_discount'];
        }
        $new_registration_date = new DateTime($student_array['student_registration_date']);
        $student_array['registration_date_text'] = $new_registration_date->format('d-m-Y');


        if($student_array['student_birthdate'] != '' && $student_array['student_birthdate'] != '0000-00-00')
        {
            $new_student_birthdate_date = new DateTime($student_array['student_birthdate']);
            $student_array['student_birthdate'] = $new_student_birthdate_date->format('d-m-Y');
        }
        else
        {
            $student_array['student_birthdate'] = '';
        }

        $country = $student_array['student_country'];
        $country_array = $this->config->item('country_array');
        $student_array['lang_preference'] = json_decode($student_array['lang_preference']);
        $student_array['student_country_text'] = $country == 0 ? ' - ' : $country_array[$country];
        $student_array['student_gender'] = $student_array['student_gender'] == MALE ? 'MALE' : 'Female';
        $student_array['student_interestedin_email'] = $student_array['student_interestedin_email'] == YES ? 'Yes' : 'No';
        $student_array['student_interestedin_message'] = $student_array['student_interestedin_message'] == YES ? 'Yes' : 'No';
        $student_array['total'] = $total;
        $student_array['paid'] = $paid;
        $student_array['due'] = $due;
        $student_array['discount'] = $discount;
        $student_array['total_discount'] = $total_discount;
        echo json_encode($student_array);
    }

    function _get_student_data_by_student_id($student_id) {
        return $this->student_master_model->get_by_student_id($student_id);
    }

    function update_student() {
        $student_id = $this->input->post('student_id');
        $student = $this->_get_student_from_post();
        $validation_message = $this->_validate_student($student);
        if ($validation_message != '') {
            echo json_encode(array('success' => false, 'message' => $validation_message));
            return;
        }
                
        if($this->input->post('student_lan_chack_box') == 1) 
        {      
            $recipe_language_data = $this->input->post('recipe_language_data');
            $student['lang_preference'] = json_encode($recipe_language_data);
        }   
        else
        {
            $student['lang_preference'] = '';
        }

        $user_id = get_from_session('ccm_user_id');
        $student['student_updated_by'] = $user_id;
        $this->student_master_model->update_student($student_id, $student);
        $student['student_id'] = $student_id;
        $this->add_area($student['student_area']);
        echo json_encode(array('success' => true, 'message' => 'Student Information Updated Successflly', 'student_id' => $student_id));
    }

    function _get_student_from_post() {
        if($this->input->post('student_birthdate') != '')
        {
            $birth_date = new DateTime($this->input->post('student_birthdate'));
            $new_birth_date = $birth_date->format('Y-m-d');
        }
        else
        {
            $new_birth_date = '';
        }
        $registration_date = new DateTime($this->input->post('student_registration_date'));

        $new_registration_date = $registration_date->format('Y-m-d');
        return array(
            'student_first_name' => strtoupper($this->input->post('student_first_name')),
            'student_middle_name' => strtoupper($this->input->post('student_middle_name')),
            'student_last_name' => strtoupper($this->input->post('student_last_name')),
            'student_gender' => $this->input->post('student_gender'),
            'student_phone' => $this->input->post('student_phone'),
            'student_mobile' => $this->input->post('student_mobile'),
            'student_email' => $this->input->post('student_email'),
            'student_birthdate' => $new_birth_date,
            'student_profession' => $this->input->post('student_profession'),
            'student_reference' => $this->input->post('student_reference'),
            'student_reference_other' => $this->input->post('student_reference_other'),
            'student_profession' => $this->input->post('student_profession'),
            'student_address' => $this->input->post('student_address'),
            'student_area' => $this->input->post('student_area'),
            'student_city' => $this->input->post('student_city'),
            'student_state' => $this->input->post('student_state'),
            'student_country' => $this->input->post('student_country'),
            'student_interestedin_email' => $this->input->post('student_interestedin_email') == NULL ? '' : $this->input->post('student_interestedin_email'),
            'student_interestedin_message' => $this->input->post('student_interestedin_message') == NULL ? '' : $this->input->post('student_interestedin_message'),
            'student_registration_date' => $new_registration_date,
            'student_group_tag' => $this->input->post('student_group_tag'),
            'student_note' => $this->input->post('student_note')
        );
    }

    function _validate_student($student) {
        if ($student['student_first_name'] == '') {
            return 'Please Enter First Name.';
        }
        if ($student['student_last_name'] == '') {
            return 'Please Enter Last Name.';
        }
        if ($student['student_mobile'] != '') {
            if ($this->_check_group_exists($student)) {
                return 'Mobile Number Exists';
            }
        }
//        if ($student['student_gender'] == '') {
//            return 'Please Enter Gender.';
//        }
//        if ($student['student_city'] == '') {
//            return 'Please Enter City.';
//        }
//        if ($student['student_state'] == '') {
//            return 'Please Enter State.';
//        }
//        if ($student['student_country'] == '') {
//            return 'Please Enter Country.';
//        }
//        if ($student['lang_preference'] == '') {
//            return 'Please Enter Language Preference.';
//        }
//        if ($student['student_registration_date'] == '') {
//            return 'Please Enter Registration Date.';
//        }
        return '';
    }

    /**
     * check for student_mobile exist or not by student_mobile
     * @return type
     */
    function _check_group_exists($student) {
        $student['student_id'] = $this->input->post('student_id');
        $student_mobail_number_info = $this->student_master_model->get_student_info($student);
        if (!empty($student_mobail_number_info)) {
            return true;
        }
        return false;
    }

    function get_image($student_id) {
        $filename = $student_id . '_' . time() . '.jpg';
        $filepath = FCPATH . "assets" . DIRECTORY_SEPARATOR . "profile_image" . DIRECTORY_SEPARATOR;
        $list = glob(FCPATH . "assets" . DIRECTORY_SEPARATOR . "profile_image" . DIRECTORY_SEPARATOR . $student_id . "_*.jpg");
        foreach ($list as $file) {
            if ($file != $filename) {
                unlink($file);
            }
        }
        move_uploaded_file($_FILES['webcam']['tmp_name'], $filepath . $filename);
        echo $filename;
    }

    function save_profile_image() {
        $student_id = $this->input->post('student_id');
        $image_name = $this->input->post('profile_image');
        $this->student_master_model->update_image($student_id, $image_name);
        echo json_encode(array('success' => true, 'message' => 'Student Image Saved Successflly!'));
    }

    function delete_profile_image() {
        $student_id = $this->input->post('student_id');
        $this->student_master_model->delete_image($student_id);
        echo json_encode(array('success' => true, 'message' => 'Student Image Deleted Successflly!'));
    }

    function get_all_student_for_tag() {
        $student_array = $this->student_master_model->get_student_distinct_group_tags();
        $student_tag_array = array();
        foreach ($student_array as $s) {
            if (!in_array($s['student_group_tag'], $student_tag_array) && $s['student_group_tag'] != '') {
                array_push($student_tag_array, $s['student_group_tag']);
            }
        }
        echo json_encode($student_tag_array);
    }

    function send_mail_and_sms() {

        $student_array = array();
        $sending_type = $this->input->post('sending_type');
        $student_array = $this->input->post('student_array');
        $student_message = $this->input->post('message');
        $come_from_module = $this->input->post('come_from_module');  
        $title = $this->input->post('title');

        $student_mobile = '';

        if($come_from_module == 'dashboard')
        {
            $student = $this->student_master_model->get_student_for_message_mail($sending_type);  
            if($student['student_id'] != '')
            {          
                $student_array = explode(",",$student['student_id']);
            }
        }
        else
        {
            $student_array = $this->input->post('student_array');
        }

        if(!empty($student_array))
        {

            if ($sending_type == 'email') {

                foreach ($student_array as $student_id) {

                    $student_data = $this->student_master_model->get_by_student_id($student_id);            
                    $student_data['student_message'] = $student_message;

                    if($student_data['student_email'] != '')
                    {
                        $this->_send_mail($student_data);
                    } 
                }
            }
            else
            {
                foreach ($student_array as $student_id) {

                    $student_data = $this->student_master_model->get_by_student_id($student_id);
                                  
                    if($student_data['student_mobile'] != '')
                    {
                        send_SMS($student_message, $student_data['student_mobile']);
                    }
                }
            }

            echo json_encode(array('success' => TRUE, 'message' => $title . ' Notification is sent successfully','student_message'=>$student_message));
        }
        else
        {
            echo json_encode(array('success' => FALSE, 'message' => 'No student available for sent '.$title,'student_message'=>$student_message));
        }
        
        
    }

    function _send_mail($data) {
        $data['subject'] = 'SWAD INSTITUTE NOTIFICATION';
        $this->load->library('email');
        $email = ($data['student_email']);
        send_email($data, $email);
    }    

    function discontinue_student_from_attendance() {
        $student_id = $this->input->post('student_id');
        $status = $this->input->post('status');
        $student_data = array('discontinue' => $status);
        $this->student_master_model->discontinue_student_from_attendance($student_id, $student_data);
        $data['success'] = true;
        if ($status == DISCONTINUEYES) {
            $data['message'] = 'Student discontinue from attendance';
        } else {
            $data['message'] = 'Student continue for attendance';
        }
        echo json_encode($data);
    }

    function delete_student() {
        $student_id = $this->input->post('student_id');
        $enrollment_exist = $this->student_enrollment_model->check_enrollment_exist($student_id);
        if (!empty($enrollment_exist)) {
            echo json_encode(array('success' => FALSE, 'message' => 'Enrollment Already Exist'));
            return;
        }
        $data = array('is_delete' => ISDELETENO, 'student_updated_date' => date('Y-m-d h:i:s'), 'student_updated_by' => get_from_session('ccm_user_id'));
        $result = $this->student_master_model->delete_student($student_id, $data);
        echo json_encode(array('success' => TRUE, 'message' => 'Delete Student Successfully'));
    }

}

/**
 * EOF: ./application/controllers/student_master.php
 */
    