<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_attendance extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('attendance_model');
        $this->load->model('student_master_model');
        $this->load->model('schedule_model');
        $this->load->model('student_enrollment_model');
        $this->load->model('interest_model');

        check_authenticated();
    }

    function get_course_schedule() {
        $student_attendance_date = new DateTime($this->input->post('attendance_date'));
        $new_student_attendance_date = $student_attendance_date->format('Y-m-d');
        $result = generate_array_for_id_object($this->attendance_model->get_course_schedule($new_student_attendance_date), 'schedule_id');
        echo json_encode($result);
    }

    function get_student_record_by_course_schedule() {
        $course_id = $this->input->post('course_id');
        $schedule_id = $this->input->post('schedule_id');
        $attendance_date = to_database_format($this->input->post('attendance_date'));
        $student_id = '';
        $enrollment_id = ''; 

        // $course_id = 4;
        // $schedule_id = 7;
        // $attendance_date = '2019-07-03';

        $schedule_detail = $this->schedule_model->get_schedule_by_id($schedule_id);       

        $total_day = $schedule_detail['course_duration'];
        $schedule_arr = array();

        if($schedule_detail['schedule_day'] == $total_day)
        {
            $schedule_arr = $this->schedule_model->get_schedule_arr1($attendance_date,$course_id,$total_day,$schedule_detail['schedule_day'],'DESC');
        }
        else
        {
            $get = $this->schedule_model->get_schedule_arr1($attendance_date,$course_id,$total_day,$schedule_detail['schedule_day'],'ASC');
            $schedule_arr = $this->schedule_model->get_schedule_arr2($get[0]['schedule_date'],$course_id,$total_day);
        }        

        $temp = array_unique(array_column($schedule_arr, 'schedule_day'));
        $schedule_arr = array_intersect_key($schedule_arr, $temp);

        function compareByName($a, $b) {
          return strcmp($a["schedule_day"], $b["schedule_day"]);
        }
        usort($schedule_arr, 'compareByName');       

        $result = $this->attendance_model->get_student_record_by_course_schedule($course_id, $enrollment_id);

        $main_array = array();
        
        foreach ($result as $course_data) {

            $course_data['course_fees'] = $schedule_detail['course_fees'];
            $course_data['schedule_date'] = $schedule_detail['schedule_date'];
            $course_data['schedule_day'] = $schedule_detail['schedule_day'];
            $course_data['schedule_date_format']=date_format(date_create($schedule_detail['schedule_date']),'d-m-Y');
            $course_data['schedule_id'] = $schedule_detail['schedule_id'];
            
            
            $student_id = $course_data['student_id'];
            $course_data['course_duration'] = 0;
            $course_duration = $this->attendance_model->get_course_duration_by_student($schedule_id, $course_data['enrollment_id']);
            if (!empty($course_duration)) {
                $course_data['course_duration'] = $course_duration['total_course_duration'];
            }

            if ($course_data['payment_amount'] == '' || $course_data['payment_amount'] == null) {
                $course_data['payment_amount'] = 0;
            }
            if ($course_data['average_amount'] == '' || $course_data['average_amount'] == null) {
                $course_data['average_amount'] = 0;
            }

            $course_data['student_attendance'] = 0;
            $student_attendance = $this->attendance_model->get_attendence_by_student($course_id, $course_data['enrollment_id']);
            if (!empty($student_attendance)) {
                $course_data['student_attendance'] = $student_attendance['total_attendance'];
                $course_data['student_attend_day'] = $student_attendance['schedule_day'];
            }

            $attendance_arr = array();

            $is_present_once = false;
            foreach ($schedule_arr as $key => $value) {
                 
                $row=$value;               

                $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id, $value['schedule_id'], $value['schedule_date'],$course_data['enrollment_id']);

                if(empty($attendance_data))
                {
                    $row['present'] = false;                       
                }
                else
                {
                    $is_present_once = true;
                    $row['present'] = true;
                }

                $last_attend = $this->attendance_model->get_last_attend_day($student_id,$value['schedule_course_id'],$value['schedule_day'],$value['schedule_date'],$course_data['enrollment_id']);                   
                if(!empty($last_attend))
                {
                    $row['present'] = true;
                    $row['last_attend_date'] = date_format(date_create($last_attend['attendance_date']),'d-m-Y');
                    $row['last_attend_date_format'] = $last_attend['attendance_date'];
                    $row['last_attend_id'] = $last_attend['attendance_id'];
                }

                $row['student_id'] = $course_data['student_id'];
                $row['enrollment_validity_date'] = $course_data['enrollment_validity_date'];
                $row['enrollment_id'] = $course_data['enrollment_id'];

                $attendance_arr[] = $row;
            }

            $course_data['attendance_arr'] = $attendance_arr;
        

            $attendance_repeated = $this->attendance_model->get_student_present_or_absent($student_id, $schedule_id, $attendance_date,$course_data['enrollment_id']);

            if(empty($attendance_repeated))
            {
                $course_data['attendance_repeated'] = false;
            }
            else
            {
                if($attendance_repeated['attendance_repeated'] == true)
                {
                    $course_data['attendance_repeated'] = true;
                    $course_data['attendance_id'] = $attendance_repeated['attendance_id'];
                    $course_data['repeated_schedule_day'] = $attendance_repeated['schedule_day'];
                }
                else
                {
                    $course_data['attendance_repeated'] = false;
                    $course_data['attendance_id'] = false;
                }
            }

            $course_data['repeated_days'] = $this->attendance_model->get_all_repeated_day($student_id,$course_data['enrollment_id'],$course_id);

            $get_food_pref = $this->attendance_model->get_food_pref($student_id,$course_id);
            $course_data['food_type'] = '';
            if(!empty($get_food_pref))
            {
                $course_data['food_type'] = $get_food_pref['food_type'];
            }            

            $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id,$schedule_id,$attendance_date,$course_data['enrollment_id']);
            if (empty($attendance_data)) 
            {               
                $course_data['absent_or_present'] = NO;
                if($course_data['student_attendance'] != 0)
                {
                    // if ($course_data['course_duration'] > $course_data['student_attendance'])
                    // {                   
                    //     array_push($main_array, $course_data);                    
                    // } 

                    $get_total_attendance_without_repeat = $this->attendance_model->get_total_attendance_without_repeat($course_id, $course_data['enrollment_id'],$schedule_id);

                    if ($course_data['course_duration'] > $get_total_attendance_without_repeat['total_attendance'])
                    {
                        array_push($main_array, $course_data);
                    }
                }
            }
            else 
            {   
                $course_data['absent_or_present'] = YES;
                array_push($main_array, $course_data);
            }
        }   

        // echo "<pre>";
        // print_r($main_array);

        echo json_encode($main_array);
    }
    function get_student_record_by_course_schedule1() {

        $course_id = $this->input->post('course_id');
        $schedule_id = $this->input->post('schedule_id');
        $status = $this->input->post('status');
        $attendance_date = to_database_format($this->input->post('attendance_date'));
        $student_id = '';
        $enrollment_id = '';

        // $course_id = 1;
        // $schedule_id = 3;
        // $status = 1;
        // $attendance_date = '2019-07-02';
        
        $schedule_detail = $this->schedule_model->get_schedule_by_id($schedule_id);

        $total_day = $schedule_detail['course_duration'];
        $schedule_arr = array();

        if($schedule_detail['schedule_day'] == $total_day)
        {
            $schedule_arr = $this->schedule_model->get_schedule_arr1($attendance_date,$course_id,$total_day,$schedule_detail['schedule_day'],'DESC');
        }
        else
        {
            $get = $this->schedule_model->get_schedule_arr1($attendance_date,$course_id,$total_day,$schedule_detail['schedule_day'],'ASC');
            $schedule_arr = $this->schedule_model->get_schedule_arr2($get[0]['schedule_date'],$course_id,$total_day);
        }        

        $temp = array_unique(array_column($schedule_arr, 'schedule_day'));
        $schedule_arr = array_intersect_key($schedule_arr, $temp);

        function compareByName($a, $b) {
          return strcmp($a["schedule_day"], $b["schedule_day"]);
        }
        usort($schedule_arr, 'compareByName');       

        $result = $this->attendance_model->get_student_record_by_course_schedule1($course_id, $enrollment_id);

        $main_array = array();
        
        foreach ($result as $course_data) {

            $course_data['schedule_date'] = $schedule_detail['schedule_date'];
            $course_data['schedule_date_format']=date_format(date_create($schedule_detail['schedule_date']),'d-m-Y');
            $course_data['schedule_id'] = $schedule_detail['schedule_id'];
            
            
            $student_id = $course_data['student_id'];
            $course_data['course_duration'] = 0;
            $course_duration = $this->attendance_model->get_course_duration_by_student($schedule_id, $course_data['enrollment_id']);
            if (!empty($course_duration)) {
                $course_data['course_duration'] = $course_duration['total_course_duration'];
            }

            if ($course_data['payment_amount'] == '' || $course_data['payment_amount'] == null) {
                $course_data['payment_amount'] = 0;
            }
            if ($course_data['average_amount'] == '' || $course_data['average_amount'] == null) {
                $course_data['average_amount'] = 0;
            }

            $course_data['student_attendance'] = 0;
            $student_attendance = $this->attendance_model->get_attendence_by_student($course_id, $course_data['enrollment_id']);
            if (!empty($student_attendance)) {
                $course_data['student_attendance'] = $student_attendance['total_attendance'];
                $course_data['student_attend_day'] = $student_attendance['schedule_day'];
            }

            $attendance_arr = array();

            foreach ($schedule_arr as $key => $value) {
                 
                $row=$value;               

                $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id, $value['schedule_id'], $value['schedule_date'],$course_data['enrollment_id']);

                if(empty($attendance_data))
                {
                    $row['present'] = false;                       
                }
                else
                {
                    $row['present'] = true;
                }

                $last_attend = $this->attendance_model->get_last_attend_day($student_id,$value['schedule_course_id'],$value['schedule_day'],$value['schedule_date'],$course_data['enrollment_id']);                   
                if(!empty($last_attend))
                {
                    $row['present'] = true;
                    $row['last_attend_date'] = date_format(date_create($last_attend['attendance_date']),'d-m-Y');
                    $row['last_attend_date_format'] = $last_attend['attendance_date'];
                    $row['last_attend_id'] = $last_attend['attendance_id'];
                }

                $row['student_id'] = $course_data['student_id'];
                $row['enrollment_validity_date'] = $course_data['enrollment_validity_date'];
                $row['enrollment_id'] = $course_data['enrollment_id'];

                $attendance_arr[] = $row;
            }

            $course_data['attendance_arr'] = $attendance_arr;
        

            $attendance_repeated = $this->attendance_model->get_student_present_or_absent($student_id, $schedule_id, $attendance_date,$course_data['enrollment_id']);

            if(empty($attendance_repeated))
            {
                $course_data['attendance_repeated'] = false;
            }
            else
            {
                if($attendance_repeated['attendance_repeated'] == true)
                {
                    $course_data['attendance_repeated'] = true;
                    $course_data['attendance_id'] = $attendance_repeated['attendance_id'];
                }
                else
                {
                    $course_data['attendance_repeated'] = false;
                    $course_data['attendance_id'] = false;
                }
            }

            $get_food_pref = $this->attendance_model->get_food_pref($student_id,$course_id);
            $course_data['food_type'] = '';
            if(!empty($get_food_pref))
            {
                $course_data['food_type'] = $get_food_pref['food_type'];
            }
            
            $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id,$schedule_id,$attendance_date,$course_data['enrollment_id']);          

            if (empty($attendance_data)) {
                $course_data['absent_or_present'] = NO;
                
                if ($course_data['student_attendance'] == 0) {
                    array_push($main_array, $course_data);
                }
                // if ($course_data['course_duration'] > $course_data['student_attendance']) {
                //     array_push($main_array, $course_data);
                // }
            } else {
                $course_data['absent_or_present'] = YES;                
                //array_push($main_array, $course_data);                
            }
        }       

        if($status == 2)
        {
            $result = array(); 

            foreach ($main_array as $row) {               

                $select = $this->interest_model->check_intrest($course_id,$row['student_id']);

                if(empty($select))
                {
                    $result[]=$row;
                }
                else
                {
                    if($select['status'] == 0)
                    {
                        $result[]=$row;
                    }
                }
            }
            echo json_encode($result);
        }
        else
        {
            $select = $this->interest_model->get_confirm_student($course_id);

            // echo "<pre>";
            // print_r($select);
            // exit;

            $result = array(); 

            foreach ($main_array as $row) {

                $res = $this->interest_model->check_intrest($course_id,$row['student_id']);

                if(!empty($res))
                {
                    if($res['status'] == 1)
                    {
                        $result[]=$row;
                    }
                }                
            }

            $result1 = array_merge($result,$select);      

            // echo "call";

            // echo "<pre>";
            // print_r($result1);
            // exit;


            echo json_encode($result1);
        }
        
    }
    function save_attendance() {
        $student_attendance_data = $this->_get_student_attendance_from_post();
        $enrollment_validity_date = $this->input->post('enrollment_validity');
        $attendance_exists = $this->attendance_model->is_attendance_exists($student_attendance_data);
        if (!empty($attendance_exists)) {
            $delete = $this->attendance_model->delete_attendance($student_attendance_data);
            echo json_encode(array('success' => TRUE, 'message' => 'Student Absent, Attendance Saved Successflly','data' =>$attendance_exists));
        }
        else
        {
            $today = date("Y-m-d");
            if ($enrollment_validity_date < $today) {
                echo json_encode(array('success' => false, 'message' => 'Validity is expired for this student & Attendance is saved successfully'));
            } else {                
                echo json_encode(array('success' => TRUE, 'message' => 'Student Present, Attendance Saved Successflly'));
            }
            $this->attendance_model->save_attendance($student_attendance_data);
        }
    }
    function delete_attendance_by_id() {
        //$student_attendance_data = $this->_get_student_attendance_from_post();
        $attendance_id = $this->input->post('attendance_id');        
        $delete = $this->attendance_model->delete_attendance_by_id($attendance_id);
        echo json_encode(array('success' => TRUE, 'message' => 'Student Attendance Removed'));
    }

    // function save_attendance() {
    //     $student_attendance_data = $this->_get_student_attendance_from_post();
    //     $enrollment_validity_date = $this->input->post('enrollment_validity');
    //     $attendance_exists = $this->attendance_model->is_attendance_exists($student_attendance_data);
    //     if (!empty($attendance_exists)) {
    //         echo json_encode(array('success' => false, 'message' => 'Student Attendance Already Present'));
    //         return;
    //     }
    //     $today = date("Y-m-d");
    //     if ($enrollment_validity_date < $today) {
    //         echo json_encode(array('success' => false, 'message' => 'Validity is expired for this student & Attendance is saved successfully'));
    //     } else {
    //         echo json_encode(array('success' => TRUE, 'message' => 'Student Attendance Saved Successflly'));
    //     }
    //     $this->attendance_model->save_attendance($student_attendance_data);
    // }

    function delete_attendance() {
        $student_attendance_data = $this->_get_student_attendance_from_post();
        $delete = $this->attendance_model->delete_attendance($student_attendance_data);
        if ($delete) {
            echo json_encode(array('success' => TRUE, 'message' => 'Student Attendance Saved Successflly'));
            return;
        }
        echo json_encode(array('success' => false, 'message' => 'Student Already Absent'));
    }

    function _get_student_attendance_from_post() {
        $student_attendance_date = new DateTime($this->input->post('student_attendance_date'));
        $new_student_attendance_date = $student_attendance_date->format('Y-m-d');
        $attendance_details = array(
            'attendance_schedule_id' => $this->input->post('attendance_schedule_id'),
            'attendance_student_id' => $this->input->post('student_attendence_id'),
            'attendance_enrollment_id' => $this->input->post('attendance_enrollment_id'),
            'attendance_repeated'=> $this->input->post('attendance_repeated'),
            'attendance_date' => $new_student_attendance_date,
            'attendance_created_by' => get_from_session('ccm_user_id'),
//            'attendance_created_date' => $new_student_attendance_date,
        );
        return $attendance_details;
    }

    function get_attendance_by_student() {
        $student_id = $this->input->post('student_id');
        $student_attendance_data = $this->attendance_model->get_attendance_by_student($student_id);
        echo json_encode($student_attendance_data);
    }

    function get_all_student_for_attendence() {
        $course_id = $this->input->post('course_id');
        $schedule_id = $this->input->post('schedule_id');
        $attendance_date = to_database_format($this->input->post('attendance_date'));
        $student_id = '';
        $enrollment_id = '';

        $schedule_detail = $this->schedule_model->get_schedule_by_id($schedule_id);

        $result = $this->attendance_model->get_student_record_by_course_schedule($course_id, $enrollment_id);
        $main_array = array();
        // select the students whose attendance for particular course is pending(i.e number of days from course days) and those whose present is done on the selected date(i.e date of attendance) on the form
        foreach ($result as $course_data) {

            $course_data['schedule_day'] = $schedule_detail['schedule_day'];

            $student_id = $course_data['student_id'];
            $course_data['course_duration'] = 0;
            $course_duration = $this->attendance_model->get_course_duration_by_student($schedule_id, $course_data['enrollment_id']);
            if (!empty($course_duration)) {
                $course_data['course_duration'] = $course_duration['total_course_duration'];
            }

            $course_data['student_attendance'] = 0;
            $student_attendance = $this->attendance_model->get_attendence_by_student($course_id, $course_data['enrollment_id']);
            if (!empty($student_attendance)) {
                $course_data['student_attendance'] = $student_attendance['total_attendance'];
            }

            $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id, $schedule_id, $attendance_date, $course_data['enrollment_id']);
            if ($course_data['payment_amount'] == '' || $course_data['payment_amount'] == null) {
                $course_data['payment_amount'] = 0;
            }
            if ($course_data['average_amount'] == '' || $course_data['average_amount'] == null) {
                $course_data['average_amount'] = 0;
            }
            if (empty($attendance_data)) 
            {
                $course_data['absent_or_present'] = NO;
                
                // if ($course_data['course_duration'] <= $course_data['student_attendance']) 
                // {
                //     array_push($main_array, $course_data);
                // }
                // if ($course_data['student_attendance'] > 0)
                // {
                //     array_push($main_array, $course_data);
                // }

                $check_attend_or_not = $this->attendance_model->check_day_attend_or_not($student_id,$course_id,$course_data['enrollment_id'],$course_data['schedule_day']);

                if(!empty($check_attend_or_not))
                {
                    array_push($main_array, $course_data);
                }
            } 
            else 
            {
                $course_data['absent_or_present'] = YES;
            }
        }
        echo json_encode($main_array);
    }    

    // function get_by_course_schedule_and_student() {
    //     $course_id = $this->input->post('course_id');
    //     $student_id = $this->input->post('student_id');
    //     $enrollment_id = $this->input->post('enrollment_id');
    //     $schedule_id = $this->input->post('schedule_id');
    //     $attendance_date = to_database_format($this->input->post('attendance_date'));

    //     $result = $this->attendance_model->get_student_record_by_course_schedule($course_id, $enrollment_id);
    //     $main_array = array();

    //     $result['course_duration'] = 0;
    //     $course_duration = $this->attendance_model->get_course_duration_by_student($schedule_id, $result['enrollment_id']);
    //     if (!empty($course_duration)) {
    //         $result['course_duration'] = $course_duration['total_course_duration'];
    //     }

    //     $result['student_attendance'] = 0;
    //     $student_attendance = $this->attendance_model->get_attendence_by_student($course_id, $result['enrollment_id']);
    //     if (!empty($student_attendance)) {
    //         $result['student_attendance'] = $student_attendance['total_attendance'];
    //     }

    //     $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id, $schedule_id, $attendance_date, $result['enrollment_id']);
    //     if ($result['payment_amount'] == '' || $result['payment_amount'] == null) {
    //         $result['payment_amount'] = 0;
    //     }
    //     if ($result['average_amount'] == '' || $result['average_amount'] == null) {
    //         $result['average_amount'] = 0;
    //     }
    //     if (empty($attendance_data)) {
    //         $result['absent_or_present'] = NO;
    //     } else {
    //         $result['absent_or_present'] = YES;
    //     }
    //     array_push($main_array, $result);
    //     $enrollment_validity_date = $result['enrollment_validity_date'];

    //     $today = date("Y-m-d");
    //     if ($enrollment_validity_date < $today) {
    //         echo json_encode(array('success' => false, 'message' => 'Student enrollment validity expire', 'data' => $main_array));
    //     } else {
    //         echo json_encode(array('success' => true, 'message' => '', 'data' => $main_array));
    //     }
    // }

    function get_by_course_schedule_and_student() {

        $course_id = $this->input->post('course_id');
        $student_id = $this->input->post('student_id');
        $enrollment_id = $this->input->post('enrollment_id');
        $schedule_id = $this->input->post('schedule_id');
        $attendance_date = to_database_format($this->input->post('attendance_date'));

        $schedule_detail = $this->schedule_model->get_schedule_by_id($schedule_id);        

        $total_day = $schedule_detail['course_duration'];
        $schedule_arr = array();

        if($schedule_detail['schedule_day'] == $total_day)
        {
            $schedule_arr = $this->schedule_model->get_schedule_arr1($attendance_date,$course_id,$total_day,$schedule_detail['schedule_day'],'DESC');
        }
        else
        {   
            $get = $this->schedule_model->get_schedule_arr1($attendance_date,$course_id,$total_day,$schedule_detail['schedule_day'],'ASC');        

            $schedule_arr = $this->schedule_model->get_schedule_arr2($get[0]['schedule_date'],$course_id,$total_day);
        }        

        function compareByName($a, $b) {
          return strcmp($a["schedule_day"], $b["schedule_day"]);
        }
        usort($schedule_arr, 'compareByName');       

        $result = $this->attendance_model->get_student_record_by_course_schedule($course_id, $enrollment_id);

        $main_array = array();     

        
        $result['schedule_date'] = $schedule_detail['schedule_date'];
        $result['schedule_day'] = $schedule_detail['schedule_day'];
        $result['schedule_date_format']=date_format(date_create($schedule_detail['schedule_date']),'d-m-Y');
        $result['schedule_id'] = $schedule_detail['schedule_id'];
            
        $result['course_duration'] = 0;
        $course_duration = $this->attendance_model->get_course_duration_by_student($schedule_id, $result['enrollment_id']);
        if (!empty($course_duration)) {
            $result['course_duration'] = $course_duration['total_course_duration'];
        }        

        $result['student_attendance'] = 0;
        $student_attendance = $this->attendance_model->get_attendence_by_student($course_id, $result['enrollment_id']);
        if (!empty($student_attendance)) {
            $result['student_attendance'] = $student_attendance['total_attendance'];
            $result['student_attend_day'] = $student_attendance['schedule_day'];
        }

        $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id,$schedule_id,$attendance_date,$result['enrollment_id']);
        if (empty($attendance_data)) {
            $result['absent_or_present'] = NO;
            
        } else {
            $result['absent_or_present'] = YES;           
        }

        if ($result['payment_amount'] == '' || $result['payment_amount'] == null) {
            $result['payment_amount'] = 0;
        }
        if ($result['average_amount'] == '' || $result['average_amount'] == null) {
            $result['average_amount'] = 0;
        }        

        $attendance_arr = array();

        foreach ($schedule_arr as $key => $value) {
             
            $row=$value;               

            $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id, $value['schedule_id'], $value['schedule_date'],$result['enrollment_id']);

            if(empty($attendance_data))
            {                
                $row['present'] = false;                                
            }
            else
            {
                $row['present'] = true;
            }
            $row['student_id'] = $result['student_id'];
            $row['enrollment_validity_date'] = $result['enrollment_validity_date'];
            $row['enrollment_id'] = $result['enrollment_id'];

            $attendance_arr[] = $row;
        }


        // foreach ($schedule_arr as $key => $value) {
             
        //     $row=$value;               

        //     $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id, $value['schedule_id'], $value['schedule_date'],$result['enrollment_id']);

        //     if(empty($attendance_data))
        //     {
        //         $last_attend = $this->attendance_model->get_last_attend_day($student_id,$value['schedule_course_id'],$value['schedule_day'],$value['schedule_date'],$course_data['enrollment_id']);
                
        //         if(empty($last_attend))
        //         {
        //             $row['present'] = false;
        //         }
        //         else
        //         {                        
        //             $row['present'] = true;
        //             $row['last_attend_date'] = date_format(date_create($last_attend['attendance_date']),'d-m-Y');
        //             $row['last_attend_date_format'] = $last_attend['attendance_date'];
        //             $row['last_attend_id'] = $last_attend['attendance_id'];
        //         }                    
        //     }
        //     else
        //     {
        //         $row['present'] = true;
        //     }
        //     $row['student_id'] = $result['student_id'];
        //     $row['enrollment_validity_date'] = $result['enrollment_validity_date'];
        //     $row['enrollment_id'] = $result['enrollment_id'];

        //     $attendance_arr[] = $row;
        // }

        $result['attendance_arr'] = $attendance_arr;
        
        array_push($main_array, $result);
        $enrollment_validity_date = $result['enrollment_validity_date'];

        $today = date("Y-m-d");
        if ($enrollment_validity_date < $today) {
            echo json_encode(array('success' => false, 'message' => 'Student enrollment validity expire', 'data' => $main_array));
        } else {
            echo json_encode(array('success' => true, 'message' => '', 'data' => $main_array));
        }
    }

    function get_by_student_id() {
        $student_id = $this->input->post('student_id');
        $student_name = $this->student_master_model->get_by_student_id($student_id);
        echo json_encode($student_name);
    }

    function give_enrollment_id_in_attendance() {
        $attendance_details = $this->attendance_model->get_attendance_details();
        foreach ($attendance_details as $attendance_data) {
            $attendance_enrollment_id = 0;
            $schedule_details = $this->schedule_model->get_schedule_by_id($attendance_data['attendance_schedule_id']);
            $enrollment_details = $this->student_enrollment_model->get_enrollment_details_by_id($schedule_details['course_id'], $attendance_data['attendance_student_id']);
            foreach ($enrollment_details as $enrollment_data) {
                $student_attendance_details = $this->attendance_model->get_attendance_detail_by_id($enrollment_data['enrollment_id'],$schedule_details['course_id']);
                $cnt = $student_attendance_details['attendance_cnt'];
                if ($cnt == 0) {
                    $attendance_enrollment_id = $enrollment_data['enrollment_id'];
                    break;
                }

                if ($cnt != 0) {
                    $course_duration = $schedule_details['course_duration'];
                    if ($cnt < $course_duration) {
                        $attendance_enrollment_id = $enrollment_data['enrollment_id'];
                        break;
                    }
                }
            }

            $this->attendance_model->update_attendance($attendance_data['attendance_id'], $attendance_enrollment_id);
        }
        echo 'success';
    }

    function send_mail_and_sms() 
    {        
        $sending_type = $this->input->post('sending_type');
        $student_array = $this->input->post('student_array');
        $schedule_id = $this->input->post('schedule_id');
        $title = $this->input->post('title');        

        foreach ($student_array as $student_id) {

            $student_data = $this->student_master_model->get_by_student_id_for_email_and_sms($student_id,$schedule_id);
            $student_mobile = $student_data['student_mobile'];            

            $schedule_date = new DateTime($student_data['schedule_date']);
            $schedule_from_time = $student_data['schedule_from_time'];
            $time_in_12_hour_format_for_schedule_from_time = date("g:i a", strtotime($schedule_from_time));
            $schedule_to_time = ($student_data['schedule_to_time']);
            $time_in_12_hour_format_for_schedule_to_time = date("g:i a", strtotime($schedule_to_time));

            $mail_and_sms_data = array();
            $mail_and_sms_data['student_mobile'] = $student_data['student_mobile'];
            $mail_and_sms_data['student_email'] = $student_data['student_email'];
            $mail_and_sms_data['day'] = $schedule_date->format('D');
            $mail_and_sms_data['from_time'] = $time_in_12_hour_format_for_schedule_from_time;
            $mail_and_sms_data['to_time'] = $time_in_12_hour_format_for_schedule_to_time;
            $mail_and_sms_data['date'] = $schedule_date->format('d-m-Y');
            $mail_and_sms_data['course_name'] = $student_data['enrollment_course_name'];
            $mail_and_sms_data['student_name'] = $student_data['student_first_name'] . ' ' . $student_data['student_last_name'];
            $mail_and_sms_data['is_course_schedule_notification'] = true;

            $body1 = str_replace('{#DATE}', $schedule_date->format('d-m-Y'), $student_message);
            $body2 = str_replace('{#DAY}', $schedule_date->format('D'), $body1);
            $body3 = str_replace('{#TIME}', $time_in_12_hour_format_for_schedule_from_time, $body2);
            $mail_and_sms_data['message_body'] = str_replace('{#COURSENAME}', $student_data['enrollment_course_name'], $body3);

            if ($sending_type == 'email')
            {
                $this->_send_mail($mail_and_sms_data);
            }
            else
            {
                $student_message = "Dear ".$mail_and_sms_data['student_name']."\n";
                $student_message .= "This is to notify you that your class is scheduled as following"."\n";
                $student_message .= "Course Name : ".$mail_and_sms_data['course_name']."\n";
                $student_message .= "Date : ".$mail_and_sms_data['date']." , ".$mail_and_sms_data['day']."\n";
                $student_message .= "Time : ".$mail_and_sms_data['from_time']." To ".$mail_and_sms_data['to_time']."\n";
                $student_message .= "Kindly be present on time.";

                if($student_data['student_mobile'] != '')
                {
                    send_SMS($student_message, $student_mobile);
                }
            }
        }        
        echo json_encode(array('success' => TRUE, 'message' => $title . ' Notification is sent successfully'));
    }
    function _send_mail($data) {
        $data['subject'] = 'SWAD INSTITUTE NOTIFICATION';
        $this->load->library('email');
        $email = ($data['student_email']);
        send_email($data, $email);
    }
    function get_ref_counter()
    {        
        if($this->input->post('course_id') != '')
        {
            $course_id = $this->input->post('course_id');
        }
        else
        {
            $course_id = '';
        }
        
        $student_reference = $this->config->item('student_reference');
        $ref_array=array();
        foreach ($student_reference as $value) {
            $result = $this->student_master_model->get_ref_counter($value,$course_id);
            $arr['name']=$value;
            $arr['count']=$result['total_count'];
            $ref_array[] = $arr;                       
        } 
        echo json_encode($ref_array);
    }
}
