<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payment extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('payment_model');
        $this->load->model('student_master_model');
        $this->load->model('student_enrollment_model');
        $this->load->model('config_model');
        check_authenticated();
    }

    function get_by_payment_id() {
        $student_id = $this->input->post('student_id');       

        $payment_details = $this->data_lib->get_payment_detail($student_id);        

        foreach ($payment_details as &$payment_data) {

            $payment_data['course_data'] = $this->student_enrollment_model->get_enrollment_course_details($payment_data['enrollment_id']);

            if(!empty($payment_data['course_data']))
            {
                foreach ($payment_data['course_data'] as $key => &$value) {

                    $result = $this->student_enrollment_model->get_attendance($payment_data['enrollment_id'],$value['course_id'],$payment_data['student_id']);
                    if(!empty($result))
                    {
                        $value['attend_day'] = date_format(date_create($result['attendance_date']),'d-m-Y');
                    }
                    else
                    {
                        $value['attend_day'] = '-';
                    }

                }
            }
        }       

        echo json_encode($payment_details);
    }

    function get_student_name_with_total() {
        $student_id = $this->input->post('student_id');
        $student_data = $this->student_master_model->get_by_student_id($student_id);
        $payment_details = $this->data_lib->get_payment_detail($student_id);
        $total = 0;
        $paid = 0;
        $due = 0;
        $discount = 0;
        foreach ($payment_details as $r) {
            $total += $r['sub_total'];
            $paid += $r['pay_amount'];
            $due += $r['due_amounts'];
            $discount += $r['discount'];
            $total_discount += $r['total_discount'];
        }
        $student_data['total'] = $total;
        $student_data['paid'] = $paid;
        $student_data['due'] = $due;
        $student_data['discount'] = $discount;
        $student_data['total_discount'] = $total_discount;
        echo json_encode($student_data);
    }

    function save_payment() {

        $type = $this->input->post('payment_type');
        $payment_data = $this->_get_payment_from_post();
        $validation_message = $this->_validate_payment($payment_data);
        if ($validation_message != '') {
            echo json_encode(array('success' => false, 'message' => $validation_message));
            return;
        }


        if($type == 'edit_payment_mode')
        {
            $payment_update_data['payment_mode'] = $this->input->post('payment_mode');
            $payment_update_data['payment_id'] = $this->input->post('payment_id');
            $this->payment_model->update_payment_mode($payment_update_data);
        }
        else if($type == 'edit_payment')
        {
            $action_type = $this->input->post('action_type');

            if($action_type == 'refund')
            {                
                $payment_update_data['payment_amount'] = '-'.$this->input->post('student_pay');
            }
            else
            {
                $payment_update_data['payment_amount'] = $this->input->post('student_pay');    
            }

            $payment_update_data['payment_mode'] = $this->input->post('payment_mode');            
            $payment_update_data['payment_reference_number'] = $this->input->post('payment_reference_number');
            $payment_update_data['payment_remarks'] = $this->input->post('payment_remarks');
            $payment_update_data['payment_id'] = $this->input->post('payment_id');
            
            $this->payment_model->update_payment($payment_update_data);
            $this->payment_model->update_enrollment_due_amount($payment_data['enrollment_id']);
        }
        else
        {
            $this->payment_model->update_due_amount($payment_data['student_id'], $payment_data['enrollment_id'], $payment_data['payment_amount']);
            $this->payment_model->create($payment_data);
        }

        if($type == 'edit_payment_mode' || $type == 'edit_payment')
        {
            echo json_encode(array('success' => TRUE, 'message' => 'Payment Updated Successfully'));
        }
        else
        {
            $stud = $this->student_master_model->get_by_student_id($payment_data['student_id']);
            $student_name = $stud['student_first_name'].' '.$stud['student_last_name'];

            if($payment_data['payment_amount'] > 0)
            {
                $message = $this->config_model->get_config_value('PAYMENT_MESSAGE_FORMAT')['config_value'];
                $send_message = str_replace("{student_name}",$student_name,$message);
                $send_message = str_replace("{payment_amount}",$payment_data['payment_amount'],$send_message);
                $send_message = str_replace("{branch_name}",BRANCH_NAME,$send_message);
                $send_message = strip_tags($send_message);
                //old message $message = 'Dear '.$student_name.' - Thank you for your payment of Rs.'.$payment_data['payment_amount'].' @'.BRANCH_NAME;
            }
            else
            {
                $payment_data['payment_amount'] = str_replace("-","",$payment_data['payment_amount']);
                $message = $this->config_model->get_config_value('PAYMENT_REFUND_MESSAGE_FORMAT')['config_value'];
                $send_message = str_replace("{student_name}",$student_name,$message);
                $send_message = str_replace("{payment_amount}",$payment_data['payment_amount'],$send_message);
                $send_message = str_replace("{branch_name}",BRANCH_NAME,$send_message);
                $send_message = strip_tags($send_message);
                //old message$message = 'Dear '.$student_name.' - We have refund Rs.'.$payment_data['payment_amount'].' @'.BRANCH_NAME;
            }
            send_SMS($send_message, $stud['student_mobile']);

            echo json_encode(array('success' => TRUE, 'message' => 'Payment Successfully'));
        }        
    }

    function _get_payment_from_post() {
        // $pay_date = new DateTime($this->input->post('pay_date'));
        // $new_pay_date = $pay_date->format('Y-m-d H:i:s');

        date_default_timezone_set('Asia/Kolkata');

        $pay_date = date_format(date_create($this->input->post('pay_date')),'Y-m-d');
        $time = date('H:i:s');
        $new_pay_date = $pay_date.' '.$time;

        $invoice_no = $this->generate_invoice_number($pay_date);

        $payment_type= $this->input->post('payment_type');
        $total_amount = $this->input->post('student_pay');

        if($payment_type == 'refund')
        {
            $total_amount = '-'.$total_amount;
        }
        return array(
            'enrollment_id' => $this->input->post('enrollment_id'),
            'student_id' => $this->input->post('student_id'),
            'payment_amount' => $total_amount,
            'payment_date' => $new_pay_date,
            'invoice_no' => $invoice_no,
            'payment_mode' => $this->input->post('payment_mode'),
            'payment_reference_number' => $this->input->post('payment_reference_number'),
            'payment_remarks' => $this->input->post('payment_remarks'),
        );
    }

    function generate_invoice_number($pay_date)
    {
        $year = date_format(date_create($pay_date),'Y');
        $month = date_format(date_create($pay_date),'m');
        $no = $this->payment_model->get_last_invoice_no($year,$month);
        if($no['invoice_no'] == 0)
        {
            $invoice_no = 1;
        }
        else
        {
            $invoice_no = ($no['invoice_no'])+1;
        }
        return $invoice_no;
    }

    function _validate_payment($payment_data) {
        if ($payment_data['payment_amount'] == '' || $payment_data['payment_amount'] == 0) {
            return 'Please Enter Amount.';
        }
        if ($payment_data['payment_date'] == '') {
            return 'Please Enter Date.';
        }
        if ($payment_data['payment_mode'] == '') {
            return 'Please Enter Payment mode.';
        }
        return '';
    }

    function delete_payment() {
        $payment_id = $this->input->post('payment_id');
        $payment_data = $this->payment_model->get_payment_by_payment_id($payment_id);
        $this->payment_model->update_due_amount_for_delete($payment_data['enrollment_id'], $payment_data['student_id'], $payment_data['payment_amount']);
        $this->payment_model->delete_payment_by_id($payment_id);
        echo json_encode(array('success' => TRUE, 'message' => 'Payment Deleted succefully'));
    }

    function generate_receipt($payment_id) {
            
        $payment_data = $this->payment_model->get_bill_pdf_data_by_payment_id($payment_id);
        $payment_date = date_format(date_create($payment_data['payment_date']),'Y-m-d');

        $all_payment_data = $this->payment_model->get_all_payment_of_enrollment($payment_data['enrollment_id'],$payment_id,$payment_data['payment_date']);

        //gen invoice no
        $invoice_no = 'S';
        $refund = 0;
        if($payment_data['payment_amount'] < 0)
        { 
            $refund = 1;           
            $invoice_no = 'SCN';
            $payment_data['payment_amount'] = str_replace("-","",$payment_data['payment_amount']);
        }

        $year = date_format(date_create($payment_date),'y');
        $month = date_format(date_create($payment_date),'m');

        $invoice_no = $invoice_no.$month.$year;
        
        if($payment_data['invoice_no'] != 0)
        {
            $invoice_no = $invoice_no.$payment_data['invoice_no'];
        }
        else
        {            
            $invoice_no = $invoice_no.$payment_data['payment_id'];
        }
        $payment_data['invoice_no'] = $invoice_no;
        $payment_data['gst_percentage'] = GST_PERCENTAGE;        
        $payment_data['gst_amount'] = round(($payment_data['gst_percentage'] / 100 ) * ($payment_data['payment_amount'] / 1.18));
        $payment_data['amount'] = $payment_data['payment_amount'] - $payment_data['gst_amount'];
        $payment_data['course'] = explode(',',$payment_data['courses']);

        $all_payment = array();

        foreach($all_payment_data as $key => $value) {
            
            if($value['payment_id'] == $payment_id)
            {
                break;
            }
            else
            {
                $all_payment[] = $value;
            }
        }      

        if(empty($all_payment))
        {            
            $total_due_amount =$payment_data['payable_amount']-$payment_data['payment_amount'];
            $total_paid_amount = $payment_data['payment_amount'];                      
        }
        else
        {
            
            $total_due_amount = $payment_data['payable_amount'] - $payment_data['payment_amount'] ;
            $total_paid_amount = $payment_data['payment_amount'];            

            foreach ($all_payment as $key => $value) {

                if($value['payment_amount'] > 0)
                {
                    $total_due_amount = $total_due_amount - $value['payment_amount'];
                    $total_paid_amount = $total_paid_amount + $value['payment_amount'];                
                }
            }
        }
        $payment_data['due'] = $total_due_amount;
        $payment_data['paid'] = $total_paid_amount;
        if($payment_data['payment_amount'] < 0)
        {
            $payment_data['payment_amount'] = str_replace("-","",$payment_data['payment_amount']);
        }
        $data['payment_data'] = $payment_data;
        $data['all_payment'] = $all_payment;

        // echo "<pre>";
        // print_r($data);
        // exit;

        if($refund == 1)
        {            
            $output = $this->load->view('student_master/credit_note', $data, TRUE);
        }
        else
        {
            $output = $this->load->view('student_master/cash_receipt', $data, TRUE);
        }        

        $this->load->library('mpdf/MPDF');
        //$mpdf = new mPDF('utf-8', 'A4', font, 0, l, r, t, b);
        $mpdf = new mPDF('utf-8', 'A4', 0, 0, 5, 5, 5, 1);
        $mpdf->WriteHTML($output);
        $mpdf->Output($payment_id . '_bill' . ".pdf", 'I');
    }
    function generate_invoice($payment_id) {

        $payment_data = $this->payment_model->get_bill_pdf_data_by_payment_id($payment_id);
        $all_payment_data = $this->payment_model->get_all_payment_sum_of_enrollment($payment_data['enrollment_id']);
        $payment_data['gst_percentage'] = GST_PERCENTAGE;
        //$payment_data['gst_amount'] = ($payment_data['gst_percentage'] / 100) * $all_payment_data['payment_amount'];
        $payment_data['gst_amount'] = round(($payment_data['gst_percentage'] / 100 ) * ($all_payment_data['payment_amount'] / 1.18));
        $payment_data['amount'] = $all_payment_data['payment_amount'] - $payment_data['gst_amount'];
        $payment_data['course'] = explode(',',$payment_data['courses']);
        $data['payment_data'] = $payment_data;
        $data['all_payment'] = $all_payment_data;

        // echo "<pre>";
        // print_r($data);
        // exit;
       
        $output = $this->load->view('student_master/bill', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        //$mpdf = new mPDF('utf-8', 'A4', font, 0, l, r, t, b);
        $mpdf = new mPDF('utf-8', 'A4', 0, 0, 5, 5, 5, 1);
        $mpdf->WriteHTML($output);
        $mpdf->Output($payment_id . '_bill' . ".pdf", 'I');
    }
    function get_payment_detail()
    {
        $payment_id = $this->input->post('payment_id');
        $payment = $this->payment_model->get_payment_detail($payment_id);
        echo json_encode($payment);
    }

    function update_enrollment_due_amount()
    {
        // $enrollment_id = 1;
        // $this->payment_model->update_enrollment_due_amount($enrollment_id);

        // echo $this->db->last_query();
    }

}

/**
     * EOF: ./application/controllers/Payment.php
     */
    