<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Courses extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('courses_model');
        $this->load->model('payment_model');
        $this->load->model('attendance_model');
        $this->load->model('interest_model');
        $this->load->model('Student_enrollment_model');
        $this->load->model('Schedule_model');
        check_authenticated();
    }

    function save_courses() {
        $courses = $this->_get_courses_from_post();
        $courses_title = $courses['course_title'];
        $course_exists = $this->courses_model->get_exists_course_details($courses_title);
        if (!empty($course_exists)) {
            echo json_encode(array('success' => FALSE, 'message' => 'Course already exists'));
            return;
        }
        $validation_message = $this->_validate_courses($courses);
        if ($validation_message != '') {
            echo json_encode(array('success' => FALSE, 'message' => $validation_message));
            return;
        }
        $user_id = get_from_session('ccm_user_id');
        $courses['course_created_by'] = $user_id;
        $courses['course_id'] = $this->courses_model->create($courses);

        echo json_encode(array('success' => TRUE, 'message' => 'Course Saved Successflly', 'course_data' => $courses));
    }

    /*function get_all_courses() {
        
        $result = $this->courses_model->get_all_type();

        foreach ($result as $key => &$value) {            
            $value['total_waiting']=$this->courses_model->get_total_waiting_student($value['course_id'],0)['total_waiting'];

            $res = $this->Student_enrollment_model->get_enrolled_student_count($value['course_id']);
            $r1 = array();            
            foreach ($res as $row) {
                $select = $this->interest_model->check_intrest($value['course_id'],$row['student_id']);                
                if(empty($select))
                {
                    $r1[]=$row;
                }
                else
                {  
                   if($select['status'] == 0)
                   {
                        $r1[]=$row;
                   }
                }
            }            
            $value['total_enrolled'] = count($r1);

            $value['total_count'] = $value['total_waiting']+$value['total_enrolled'];
        }       

        function sortByOrder($a, $b) {
            return $a['total_count'] < $b['total_count'];
        }
        usort($result, 'sortByOrder');
        echo json_encode($result);
    }*/

    function get_all_courses() {
        
        $result = $this->courses_model->get_all_type();
        $course = array();
        foreach ($result as $key => $value) {
            $schedule = $this->Schedule_model->get_last_scheduled($value['course_id']);                        
            $get_student = $this->attendance_model->getWaitingStudent($value['course_id'],$schedule['schedule_id'],$schedule_date['schedule_date']);
            $result = array();
            foreach ($get_student as $row) {
                $select = $this->interest_model->check_intrest($value['course_id'],$row);
                if(empty($select))
                {
                    $result[]=$row;
                }
                else
                {
                    if($select['status'] == 0)
                    {
                        $result[]=$row;
                    }
                }
            }
            if(empty($schedule))
            {
                $value['schedule'] = false;
            }
            else
            {
                $value['schedule'] = true;
            }
            
            $value['schedule_date'] = $schedule['schedule_date'];
            $value['schedule_id'] = $schedule['schedule_id'];
            $value['total_enrolled'] = count($result);
            $total_waiting = $this->interest_model->get_student_interested_data_by_course_id($value['course_id'],0);
            $value['total_waiting'] = count($total_waiting);
            $value['total_count'] = $value['total_enrolled'] + $value['total_waiting'];
            $course[] = $value;
        }
        function sortByOrder($a, $b) {
            
            $c = $a['total_count'] < $b['total_count'];
            $c .= $a['schedule_id'] < 1;
            
            return $c;
        }
        usort($course, 'sortByOrder');
        echo json_encode($course);
    }

    function get_by_courses_id() {
        $courses_id = $this->input->post('course_id');
        $courses_array = $this->courses_model->get_by_courses_id($courses_id);
        echo json_encode($courses_array);
    }

    function update_courses() {
        $courses_id = $this->input->post('course_id');
        $courses = $this->_get_courses_from_post();
        $validation_message = $this->_validate_courses($courses);
        if ($validation_message != '') {
            echo json_encode(array('success' => false, 'message' => $validation_message));
            return;
        }
        $user_id = get_from_session('ccm_user_id');
        $courses['course_updated_by'] = $user_id;
        $this->courses_model->update_courses($courses_id, $courses);
        $courses['course_id'] = $courses_id;
        echo json_encode(array('success' => true, 'message' => 'Course Updated Successflly', 'course_data' => $courses));
    }

    function delete_course() {
        $courses_id = $this->input->post('course_id');
        $check_existing_courses_in_interest = $this->courses_model->get_interest_by_course_id($courses_id);
        if (!empty($check_existing_courses_in_interest)) {
            echo json_encode(array('success' => FALSE, 'message' => 'You Cannot Delete This Course It has interested students'));
            return;
        }
        $check_existing_courses_in_enrollment = $this->courses_model->get_enrollment_by_course_id($courses_id);
        if (!empty($check_existing_courses_in_enrollment)) {
            echo json_encode(array('success' => FALSE, 'message' => 'You Cannot Delete This Course It Is Used In Enrollment Course'));
            return;
        }
        $check_existing_courses_in_schedule = $this->courses_model->get_schedule_by_course_id($courses_id);
        if (!empty($check_existing_courses_in_schedule)) {
            echo json_encode(array('success' => FALSE, 'message' => 'You Cannot Delete This Course It Is Used In Schedule'));
            return;
        }
        $this->courses_model->delete_course_by_id($courses_id);
        echo json_encode(array('success' => true, 'message' => 'Course deleted successfully'));
    }

    function _get_courses_from_post() {
        return array(
            'course_title' => strtoupper($this->input->post('courses_title')),
            'course_description' => $this->input->post('courses_description'),
            'course_duration' => $this->input->post('courses_duration'),
            'course_fees' => $this->input->post('courses_fees'),
            'course_is_active' => $this->input->post('courses_is_active'),
            'course_is_selling' => $this->input->post('courses_is_selling')
        );
    }

    function _validate_courses($courses) {
        if ($courses['course_title'] == '') {
            return 'Please Enter Course Title.';
        }
        if ($courses['course_duration'] == '') {
            return 'Please Enter Course Duration.';
        }
        if ($courses['course_fees'] == '') {
            return 'Please Enter Rate.';
        }
        return '';
    }

    function get_enrollment_details() {
        $course_id = $this->input->post('course_id');
        $post_from_date = $this->input->post('from_date');
        if ($post_from_date != '') {
            $from_date = to_database_format($post_from_date);
        } else {
            $from_date = '';
        }
        $post_to_date = $this->input->post('to_date');
        if ($post_to_date != '') {
            $to_date = to_database_format($post_to_date);
        } else {
            $to_date = '';
        }
        $enrollment_details = $this->courses_model->get_enrollment_details($course_id, $from_date, $to_date);

        $course_student = array();

        foreach ($enrollment_details as &$enrollment_data) {
            $enrollment_data['payment_details'] = $this->payment_model->get_payments($enrollment_data['enrollment_id'], $enrollment_data['student_id']);
            $amount = 0;
            foreach ($enrollment_data['payment_details'] as &$e) {
                $amount += $e['payment_amount'];
            }
            $enrollment_data['paid_amount'] = $amount;
            $enrollment_data['has_remaining_attendance'] = 'yes';
            $student_attendance = $this->attendance_model->get_attendence_by_student($course_id, $enrollment_data['enrollment_id']);
            if (!empty($student_attendance)) {
                if ($student_attendance['total_attendance'] < $enrollment_data['course_duration']) {
                    $enrollment_data['has_remaining_attendance'] = 'yes';                    
                } else {
                    $enrollment_data['has_remaining_attendance'] = 'no';
                    $course_student[]=$enrollment_data;
                }
            }
            
        }
        //echo json_encode($enrollment_details);
        echo json_encode(array('enrollment_details'=>$enrollment_details,'course_student'=>$course_student));
    }

    function export_course_student()
    {        
        $export_type = $this->input->post('course_student_export_type');
        
        $course_id = $this->input->post('course_student_course_id');

        $post_from_date = $this->input->post('from_date');
        if ($post_from_date != '') {
            $from_date = to_database_format($post_from_date);
        } else {
            $from_date = '';
        }
        $post_to_date = $this->input->post('to_date');
        if ($post_to_date != '') {
            $to_date = to_database_format($post_to_date);
        } else {
            $to_date = '';
        }

        $enrollment_details = $this->courses_model->get_enrollment_details($course_id, $from_date, $to_date);

        $course_student = array();

        foreach ($enrollment_details as &$enrollment_data) 
        {
            $enrollment_data['payment_details'] = $this->payment_model->get_payments($enrollment_data['enrollment_id'], $enrollment_data['student_id']);
            $amount = 0;
            foreach ($enrollment_data['payment_details'] as &$e) {
                $amount += $e['payment_amount'];
            }
            $enrollment_data['paid_amount'] = $amount;
            $enrollment_data['has_remaining_attendance'] = 'yes';
            $student_attendance = $this->attendance_model->get_attendence_by_student($course_id, $enrollment_data['enrollment_id']);
            if (!empty($student_attendance)) {
                if ($student_attendance['total_attendance'] < $enrollment_data['course_duration']) {
                    $enrollment_data['has_remaining_attendance'] = 'yes';                    
                } else {
                    $enrollment_data['has_remaining_attendance'] = 'no';
                    $course_student[]=$enrollment_data;
                }
            }            
        }

        $course_detail = $this->courses_model->get_by_courses_id($course_id);

        
        $data['course_detail'] = $course_detail;
        $data['course_student'] = $course_student;


        if($export_type == 'pdf')
        {
            $output = $this->load->view('courses/course_student_pdf', $data, TRUE);
            $this->load->library('mpdf/MPDF');
            //$mpdf = new mPDF('utf-8', 'A4', font, 0, l, r, t, b);
            $mpdf = new mPDF('utf-8', 'A4', 0, 0, 5, 5, 5, 1);
            $mpdf->WriteHTML($output);
            $mpdf->Output("course_students_pdf.pdf", 'I');
        }
        else
        {
            include_once APPPATH . "libraries/PHPExcel/Classes/PHPExcel.php";
            $objPHPExcel = new PHPExcel();
            $objRichText = new PHPExcel_RichText();

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', $course_detail['course_title']);

            $objPHPExcel->getActiveSheet()->SetCellValue('A3', 'Sr #');
            $objPHPExcel->getActiveSheet()->SetCellValue('B3', 'Full Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('C3', 'Mobile');
            $objPHPExcel->getActiveSheet()->SetCellValue('D3', 'Enrollment Date');
            $objPHPExcel->getActiveSheet()->SetCellValue('E3', 'Paid Amount');

            $c=4;
            //$i = count($data['student_array']);
            $count = 1;
            foreach ($data['course_student'] as $student)
            {
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$c, $count);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$c, $student['student_first_name'] . ' ' . $student['student_middle_name'] . ' ' . $student['student_last_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$c, $student['student_mobile']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$c, $student['enrollment_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$c, $student['paid_amount']);
                $c++;
                //$i--;
                $count++;
            }

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:E1'); // merge cell

            //set bg color
                $objPHPExcel->getActiveSheet()->getStyle('A1')->getFill()->applyFromArray(array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'startcolor' => array(
                         'rgb' => "538ed5"
                    )
                ));

                $objPHPExcel->getActiveSheet()->getStyle('A3:E3')->getFill()->applyFromArray(array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'startcolor' => array(
                         'rgb' => "8db4e3"
                    )
                ));
            //set bg color

            //set font color
                $styleArray1 = array(
                'font'  => array(
                    'bold' => true,
                    'color' => array('rgb' => 'ffffff'),
                    'size'  => 13,                
                ));

                $styleArray2 = array(
                'font'  => array(
                    'bold' => true,
                    'color' => array('rgb' => 'ffffff'),                               
                ));

                $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray1);
                $objPHPExcel->getActiveSheet()->getStyle('A3:E3')->applyFromArray($styleArray2);
            //set font color

            //set autosize
                for($col = 'A'; $col !== 'E'; $col++) {
                    $objPHPExcel->getActiveSheet()
                        ->getColumnDimension($col)
                        ->setAutoSize(true);
                }
            //set autosize

            //set left
                $style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
                    )
                );
                for($i=2;$i<=$c-1;$i++)
                {
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$i.':E'.$i)->applyFromArray($style);
                }
            //set left

            //set border
                $border_style = array(
                    'borders' => array(
                        'outline' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('rgb' => '538ed5'),
                        ),
                    ),
                );             
                $objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('C3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('D3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('E3')->applyFromArray($border_style);               
                              
            //set border

            $filename ='course_students_excel.xls';
            $objPHPExcel->getActiveSheet()->setTitle('Course Student');
            $objPHPExcel->setActiveSheetIndex(0);
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=\"".$filename."\";");
            header("Cache-Control: max-age=1");
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
        }
    }
    function get_all_groups()
    {
        $result = $this->courses_model->get_all_groups();        
        echo json_encode($result);        
    }
    function save_group()
    {
        date_default_timezone_set('Asia/Kolkata');

        $group['group_name'] = $this->input->post('group_name');
        $group['created_date'] = date('Y-m-d h:i:s');

        $res = $this->courses_model->check_group_name($group['group_name'],'');
        if(!empty($res))
        {
            echo json_encode(array('success' => FALSE, 'message' => 'Group name already exists'));
            exit;
        }

        $group_id=$this->courses_model->save_group($group);

        $courses = $this->input->post('course_list');
        foreach ($courses as $key => $value)
        {
            $group_courses[] = array(
                'group_id' => $group_id,
                'course_id' => $value['course_id']
            );
        }

        $this->courses_model->save_group_courses($group_courses,'');
        echo json_encode(array('success' => TRUE, 'message' => 'Group Added'));
    }
    function update_group()
    {       
        $group['group_id'] = $this->input->post('group_id');
        $group['group_name'] = $this->input->post('group_name');

        $res = $this->courses_model->check_group_name($group['group_name'],$group['group_id']);
        if(!empty($res))
        {
            echo json_encode(array('success' => FALSE, 'message' => 'Group name already exists'));
            exit;
        }

        $this->courses_model->update_group($group);

        $courses = $this->input->post('course_list');
        foreach ($courses as $key => $value)
        {
            $group_courses[] = array(
                'group_id' => $group['group_id'],
                'course_id' => $value['course_id']
            );
        }

        $this->courses_model->save_group_courses($group_courses,$group['group_id']);

        echo json_encode(array('success' => TRUE, 'message' => 'Group Added'));

    }
    function delete_group()
    {
        $group_id = $this->input->post('group_id');
        $this->courses_model->delete_group($group_id);
        echo json_encode(array('success' => TRUE, 'message' => 'Group Deleted'));
    }
    function delete_group_course()
    {
        $group_course_id = $this->input->post('group_course_id');
        $this->courses_model->delete_group_course($group_course_id);
        echo json_encode(array('success' => TRUE, 'message' => 'Course Deleted'));
    }
    function get_all_groups_course()
    {
        $group_id = $this->input->post('group_id');
        $result = $this->courses_model->get_group_courses($group_id);
        echo json_encode($result);
    }
    function get_group_detail()
    {
        $group_id = $this->input->post('group_id');
        $result = $this->courses_model->get_group_detail_from_id($group_id);
        $result['courses'] = $this->courses_model->get_group_courses($group_id);
        echo json_encode($result);
    }


}

/**
 * EOF: ./application/controllers/Courses.php
 */
