<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Interest_model extends CI_Model {

    function get_student_interest_data_by_student_id($student_id) {
        $this->db->select('si.*,c.course_title,c.course_fees,DATE_FORMAT(created_date, "%d-%m-%Y") as created_date');
        $this->db->from('student_interest si');
        $this->db->join('course c','c.course_id=si.course_id');
        $this->db->where('si.student_id', $student_id);
        $this->db->where('si.is_delete',0);
        return $this->db->get()->result_array();
    }

    function insert_student_interest_course($student_enrollment_course) {
        $this->db->insert_batch('student_interest', $student_enrollment_course);
        return $this->db->insert_id();
    }

    function delete_student_interest_old_data($student_id) {
        $this->db->where('student_id', $student_id);
        $this->db->where('enrollment_course_id', 0);
        $this->db->delete('student_interest');
    }    

    // function get_student_interested_data_by_course_id($course_id,$status) {
    //     $this->db->select('e.*,s.*,s.student_id,si.course_id,si.next,si.status,si.food_type,count(e.enrollment_id) AS total_enrollment,sum(e.due_amounts) AS due_amounts');        
    //     $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
    //     $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
    //     $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');
    //     $this->db->from('student_interest AS si');
    //     $this->db->where('si.course_id', $course_id);
    //     if($status != '')
    //     $this->db->where('si.status',$status);
    //     if($status == 0)
    //     {
    //         $this->db->where('si.enrollment_course_id =',0);
    //     }
    //     $this->db->where('s.is_delete', ISDELETEYES);
    //     $this->db->join('student_master  AS s', 'si.student_id=s.student_id');
    //     $this->db->join('enrollment as e', 's.student_id=e.student_id', 'left');
    //     $this->db->group_by('s.student_id');
    //     $this->db->order_by('si.enrollment_course_id','DESC');
    //     $res = $this->db->get();
    //     return $res->result_array();
    // }
    // function get_student_interested_data_by_course_id($course_id,$status) {

    //     $this->db->select('e.*,ec.enrollment_course_id,s.*,si.course_id,si.next,si.status,si.food_type,count(e.enrollment_id) AS total_enrollment,sum(e.due_amounts) AS due_amounts');
    //     $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
    //     $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
    //     $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');
    //     $this->db->from('student_interest si');
    //     $this->db->join('student_master s','s.student_id=si.student_id');
    //     $this->db->join('enrollment as e', 'e.student_id=s.student_id', 'left');
    //     $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id AND ec.course_id=si.course_id', 'left');
    //     $this->db->where('si.course_id',$course_id);
    //     $this->db->where('si.status',$status);
    //     $this->db->where('s.is_delete', ISDELETEYES);
    //     if($status == 0)
    //     {
    //         $this->db->where('si.enrollment_course_id',0);
    //     }
    //     $this->db->group_by('s.student_id');
    //     $res = $this->db->get();        
    //     return $res->result_array();
    // }
    // function get_student_interested_data_by_course_id($course_id,$status) {

    //     $this->db->select('e.*,ec.enrollment_course_id,s.*,si.course_id,si.next,si.status,si.food_type,count(e.enrollment_id) AS total_enrollment,sum(e.due_amounts) AS due_amounts');
    //     $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
    //     $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
    //     $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');
    //     $this->db->from('student_interest si');
    //     $this->db->join('student_master s','s.student_id=si.student_id');


    //     $this->db->join('enrollment as e', 'e.student_id=s.student_id', 'left');
    //     $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id AND ec.course_id=si.course_id', 'left');

    //     //$this->db->join('enrollment_course ec','ec.enrollment_course_id=si.enrollment_course_id', 'left');
    //     //$this->db->join('enrollment as e', 'e.enrollment_id=ec.enrollment_id', 'left');


    //     $this->db->where('si.course_id',$course_id);
    //     $this->db->where('si.status',$status);
    //     $this->db->where('s.is_delete', ISDELETEYES);
    //     if($status == 0)
    //     {
    //         $this->db->where('si.is_delete',0);
    //         $this->db->where('si.enrollment_course_id',0);
    //     }
    //     $this->db->group_by('s.student_id');
    //     $res = $this->db->get();        
    //     return $res->result_array();
    // }
    function get_student_interested_data_by_course_id($course_id,$status) {

        $this->db->select('e.*,ec.enrollment_course_id,s.*,si.student_interest_id,si.student_id,si.course_id,si.next,si.status,si.food_type,count(e.enrollment_id) AS total_enrollment,sum(e.due_amounts) AS due_amounts');
        $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
        $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
        $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');
        $this->db->from('student_interest si');
        $this->db->join('student_master s','s.student_id=si.student_id');


        // $this->db->join('enrollment as e', 'e.student_id=s.student_id', 'left');
        // $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id AND ec.course_id=si.course_id AND ec.enrollment_course_id = si.enrollment_course_id', 'left');

        $this->db->join('enrollment_course ec','ec.enrollment_course_id=si.enrollment_course_id', 'left');
        $this->db->join('enrollment as e', 'e.enrollment_id=ec.enrollment_id', 'left');


        $this->db->where('si.course_id',$course_id);
        $this->db->where('si.status',$status);
        $this->db->where('s.is_delete', ISDELETEYES);
        if($status == 0)
        {
            $this->db->where('si.is_delete',0);
            $this->db->where('si.enrollment_course_id',0);
        }
        $this->db->group_by('si.student_id');
        $res = $this->db->get();        
        return $res->result_array();
    }
    function get_confirm_student($course_id){
        $this->db->select('e.*,ec.enrollment_course_id,s.*,s.student_id,si.student_interest_id,si.course_id,si.next,si.status,si.food_type,count(e.enrollment_id) AS total_enrollment,sum(e.due_amounts) AS due_amounts');        
        $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
        $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
        $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');
        $this->db->from('student_interest AS si');
        $this->db->where('si.course_id', $course_id);        
        $this->db->where('si.status',1);
        $this->db->where('si.enrollment_course_id',0);
        $this->db->where('s.is_delete', ISDELETEYES);
        $this->db->join('student_master  AS s', 'si.student_id=s.student_id');

        // $this->db->join('enrollment as e', 's.student_id=e.student_id','left');
        // $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id AND ec.course_id=si.course_id ', 'left');

        $this->db->join('enrollment_course ec','ec.enrollment_course_id=si.enrollment_course_id', 'left');
        $this->db->join('enrollment as e', 'e.enrollment_id=ec.enrollment_id', 'left');

        $this->db->group_by('s.student_id');
        $this->db->order_by('si.enrollment_course_id','DESC');
        $res = $this->db->get();
        return $res->result_array();
    }
    function get_detail_for_confirm($student_id,$course_id) {
        $this->db->select('s.*,si.*');
        $this->db->from('student_interest si');
        $this->db->join('student_master s','s.student_id=si.student_id');
        $this->db->where('si.student_id',$student_id);
        $this->db->where('si.course_id',$course_id);
        return $this->db->get()->row_array();
    }    
    function confirm_student_to_course($data,$update)
    {
        $this->db->select('si.*');
        $this->db->from('student_interest si');
        $this->db->where('student_id',$data['student_id']);
        $this->db->where('course_id',$data['course_id']);
        $this->db->where('is_delete',0);
        $res = $this->db->get()->row_array();

        if(empty($res))
        {
            $this->db->insert('student_interest', $data);
        }
        else
        {
            $this->db->where('student_interest_id', $res['student_interest_id']);
            $this->db->where('student_id', $data['student_id']);
            $this->db->where('course_id', $data['course_id']);
            $this->db->set('food_type', $data['food_type']);            
            $this->db->set('enrollment_course_id', $data['enrollment_course_id']);
            $this->db->set('is_delete', $data['is_delete']);
            if($update)
            {
                $this->db->set('status', $res['status']);
            }
            else
            {
                $this->db->set('status', $data['status']);
            }            
            $this->db->update('student_interest'); 
        }        
    }
    function confirm_student_to_course_by_validate($data,$enrollment_course_id)
    {
        $this->db->select('si.*');
        $this->db->from('student_interest si');
        $this->db->where('student_id',$data['student_id']);
        $this->db->where('course_id',$data['course_id']);
        $this->db->order_by('student_interest_id','DESC');
        $res = $this->db->get()->row_array();

        if(empty($res))
        {
            $this->db->insert('student_interest', $data);
        }
        else
        {
            if($res['is_delete'] == 1 && $enrollment_course_id != $res['enrollment_course_id'])
            {
                $this->db->insert('student_interest', $data);
            }
            else
            {
                $this->db->where('student_interest_id', $res['student_interest_id']);
                $this->db->where('student_id', $data['student_id']);
                $this->db->where('course_id', $data['course_id']);
                $this->db->set('food_type', $data['food_type']);
                $this->db->set('enrollment_course_id', $data['enrollment_course_id']);                               
                $this->db->set('status', $data['status']);                       
                $this->db->update('student_interest'); 
            }
        }
        
    }
    function insert_interest_student_course($data)
    {
        $this->db->select('si.*');
        $this->db->from('student_interest si');
        $this->db->where('student_id',$data['student_id']);
        $this->db->where('course_id',$data['course_id']);
        $res = $this->db->get()->result_array();

        if(empty($res))
        {
            $this->db->insert('student_interest', $data);
        }
        // else
        // {
        //     $this->db->where('student_id', $data['student_id']);
        //     $this->db->where('course_id', $data['course_id']);
        //     $this->db->update('student_interest');
        // }
        
    }
    function reset_student_to_waiting($student_id,$course_id,$enrollment_course_id,$student_interest_id)
    {
        $this->db->where('student_interest_id', $student_interest_id);
        $this->db->where('student_id', $student_id);
        $this->db->where('course_id', $course_id);
        if($enrollment_course_id != '')
        {
            $this->db->where('enrollment_course_id',$enrollment_course_id);
        }
        $this->db->set('food_type', '');
        $this->db->set('status', WAITING);
        $this->db->set('next', IS_NEXT_NO);
        //$this->db->set('enrollment_course_id',0);
        $this->db->update('student_interest');
    }

    function reset_confirm_list($course_id)
    {
        $this->db->where('course_id', $course_id);
        $this->db->set('status', WAITING);
        $this->db->set('next', IS_NEXT_NO);
        //$this->db->set('enrollment_course_id',0);
        $this->db->update('student_interest');
    }
    function remove_student_from_course($student_id,$course_id)
    {
        $this->db->select('si.*');
        $this->db->from('student_interest si');
        $this->db->where('student_id',$student_id);
        $this->db->where('course_id',$course_id);        
        $this->db->where('enrollment_course_id',0);
        $res = $this->db->get()->result_array();
        if($res)
        {
            $this->db->where('student_id', $student_id);
            $this->db->where('course_id', $course_id);
            $this->db->delete('student_interest');
            return true;
        }
        else
        {
            return $res;
            //return false;
        }        
    }
    function set_interest_to_next_class($student_id,$course_id)
    {
        $this->db->where('student_id', $student_id);
        $this->db->where('course_id', $course_id);
        $this->db->set('next', IS_NEXT_YES);
        $this->db->update('student_interest');
    }    
    function remove_interest_from_next_class($student_id,$course_id)
    {
        $this->db->where('student_id', $student_id);
        $this->db->where('course_id', $course_id);
        $this->db->set('next', IS_NEXT_NO);
        $this->db->update('student_interest');
    }
    
    function delete_student_interest_enrolled_data($student_id, $course_id) {
        $this->db->where('student_id', $student_id);
        $this->db->where('course_id', $course_id);
        $this->db->delete('student_interest');
    }

    function check_intrest($course_id,$student_id) {

        $this->db->select('si.*');
        $this->db->from('student_interest si');
        $this->db->where('si.course_id',$course_id);
        $this->db->where('si.student_id',$student_id);
        $res = $this->db->get();
        return $res->row_array();
    }

    function check_intrest_for_intrested_list($course_id,$student_id) {

        $this->db->select('si.*');
        $this->db->from('student_interest si');
        $this->db->where('si.course_id',$course_id);
        $this->db->where('si.student_id',$student_id);
        $this->db->order_by('si.student_interest_id','DESC');
        $res = $this->db->get();
        return $res->row_array();
    }

    function get_other_interest($student_id,$course_id) {

        $this->db->select('*');
        $this->db->from('student_interest');
        $this->db->where('student_id',$student_id);
        $this->db->where('is_delete',0);
        $this->db->where('course_id NOT IN ('.$course_id.')');
        $res = $this->db->get();
        return $res->result_array();

    }

    function delete_interested_course($student_id,$course_id) {
        $this->db->where('student_id', $student_id);
        $this->db->where('enrollment_course_id', 0);
        $this->db->delete('student_interest');
    }

    function delete_interest($student_interest_id)
    {
        $this->db->where('student_interest_id',$student_interest_id);
        $this->db->delete('student_interest');
    }

    function update_interest($student_interest_id,$date)
    {
        $this->db->set('is_delete',1);
        $this->db->set('created_date',$date);
        $this->db->where('student_interest_id',$student_interest_id);
        $this->db->update('student_interest');
    }

    function update_interest_time($value)
    {
        $this->db->set('created_date',$value['created_date']);
        $this->db->where('student_interest_id',$value['student_interest_id']);
        $this->db->update('student_interest');
    }

    function check_interest($student_id,$course_id)
    {
        $this->db->select('*');
        $this->db->from('student_interest');
        $this->db->where('student_id',$student_id);
        $this->db->where('course_id',$course_id);
        $this->db->where('is_delete',0);
        $res = $this->db->get();
        return $res->row_array();
    }

    function add_intrest($interest)
    {
        $this->db->insert('student_interest',$interest);
    }

    function delete_all_intrest($student_id)
    {
        $this->db->where('student_id',$student_id);
        $this->db->where('is_delete',0);
        $this->db->delete('student_interest');
    }

}
