<?php ob_start(); ?>

    <script>

        Vue.component('stm-editor', {
            props: ['content', 'listener'],
            data: function () {
                return {
                    content_edited: '',
                    /* Your data and models here */
                    myPlugins : [
                        'advlist autolink lists link textcolor',
                        'searchreplace visualblocks code fullscreen',
                        'insertdatetime media table contextmenu paste code directionality template colorpicker textpattern'
                    ],
                    myToolbar1: 'undo redo | bold italic strikethrough | forecolor backcolor | template link | bullist numlist | ltr rtl | removeformat',
                    myToolbar2 : '',
                    myOtherOptions : {
                        height: 300,
                    }
                }
            },
            mounted: function () {
                var _this = this;
                _this.content_edited = _this.content;
                if(_this.listener) {
                    STM_LMS_EventBus.$on('STM_LMS_Editor_Changed', function (content) {
                        _this.content_edited = content;
                    });
                }
            },
            components: {
                //'editor': TinymceVue.default
                'tinymce': VueEasyTinyMCE
            },
            template: '<?php echo preg_replace(
				"/\r|\n/",
				"",
				addslashes(STM_LMS_Templates::load_lms_template('manage_course/forms/html/editor'))
			); ?>',
            methods: {

            },
            watch: {
                content_edited: function () {
                    var _this = this;
                    this.$emit('content-changed', _this.content_edited);
                },
            }
        });

    </script>

<?php wp_add_inline_script('stm-lms-manage_course', str_replace(array('<script>', '</script>'), '', ob_get_clean())); ?>